package mmdb

// structs of record types to pass into maxmindDB::Lookup
type mmCountry struct {
	ISOCode string  `maxminddb:"iso_code"`
	Names   mmNames `maxminddb:"names"`
}

type mmCity struct {
	Names mmNames `maxminddb:"names"`
}

type mmNames struct {
	EN string `maxminddb:"en"`
}
type mmPostal struct {
	Code string `maxminddb:"code"`
}

type mmLocationRecord struct {
	Country mmCountry `maxminddb:"country"`
	City    mmCity    `maxminddb:"city"`
	Postal  mmPostal  `maxminddb:"postal"`
}

type mmISPRecord struct {
	ISP             string `maxminddb:"isp"`
	Organization    string `maxminddb:"organization"`
	ASN             uint32 `maxminddb:"autonomous_system_number"`
	ASNOrganization string `maxminddb:"autonomous_system_organization"`
}
