// Code generated by protoc-gen-twirp v8.1.0, DO NOT EDIT.
// source: carrot_stream_analysis.proto

package rpc

import context "context"
import fmt "fmt"
import http "net/http"
import ioutil "io/ioutil"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

import bytes "bytes"
import errors "errors"
import io "io"
import path "path"
import url "net/url"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// ==============================
// CarrotStreamAnalysis Interface
// ==============================

type CarrotStreamAnalysis interface {
	GetChannelSessions(context.Context, *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error)

	GetSessionData(context.Context, *GetSessionDataRequest) (*GetSessionDataResponse, error)

	GetCapturedFileDetail(context.Context, *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error)

	ListCapturedFiles(context.Context, *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error)

	GetCapturedFileDownloadLink(context.Context, *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error)
}

// ====================================
// CarrotStreamAnalysis Protobuf Client
// ====================================

type carrotStreamAnalysisProtobufClient struct {
	client      HTTPClient
	urls        [5]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotStreamAnalysisProtobufClient creates a Protobuf client that implements the CarrotStreamAnalysis interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewCarrotStreamAnalysisProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotStreamAnalysis {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_stream_analysis", "CarrotStreamAnalysis")
	urls := [5]string{
		serviceURL + "GetChannelSessions",
		serviceURL + "GetSessionData",
		serviceURL + "GetCapturedFileDetail",
		serviceURL + "ListCapturedFiles",
		serviceURL + "GetCapturedFileDownloadLink",
	}

	return &carrotStreamAnalysisProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotStreamAnalysisProtobufClient) GetChannelSessions(ctx context.Context, in *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	caller := c.callGetChannelSessions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelSessionsRequest) when calling interceptor")
					}
					return c.callGetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisProtobufClient) callGetChannelSessions(ctx context.Context, in *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
	out := new(GetChannelSessionsResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisProtobufClient) GetSessionData(ctx context.Context, in *GetSessionDataRequest) (*GetSessionDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	caller := c.callGetSessionData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSessionDataRequest) (*GetSessionDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSessionDataRequest) when calling interceptor")
					}
					return c.callGetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisProtobufClient) callGetSessionData(ctx context.Context, in *GetSessionDataRequest) (*GetSessionDataResponse, error) {
	out := new(GetSessionDataResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisProtobufClient) GetCapturedFileDetail(ctx context.Context, in *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	caller := c.callGetCapturedFileDetail
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDetailRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisProtobufClient) callGetCapturedFileDetail(ctx context.Context, in *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
	out := new(GetCapturedFileDetailResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisProtobufClient) ListCapturedFiles(ctx context.Context, in *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "ListCapturedFiles")
	caller := c.callListCapturedFiles
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListCapturedFilesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListCapturedFilesRequest) when calling interceptor")
					}
					return c.callListCapturedFiles(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListCapturedFilesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListCapturedFilesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisProtobufClient) callListCapturedFiles(ctx context.Context, in *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
	out := new(ListCapturedFilesResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisProtobufClient) GetCapturedFileDownloadLink(ctx context.Context, in *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	caller := c.callGetCapturedFileDownloadLink
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisProtobufClient) callGetCapturedFileDownloadLink(ctx context.Context, in *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
	out := new(GetCapturedFileDownloadLinkResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ================================
// CarrotStreamAnalysis JSON Client
// ================================

type carrotStreamAnalysisJSONClient struct {
	client      HTTPClient
	urls        [5]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewCarrotStreamAnalysisJSONClient creates a JSON client that implements the CarrotStreamAnalysis interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewCarrotStreamAnalysisJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) CarrotStreamAnalysis {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "starfruit.carrot_stream_analysis", "CarrotStreamAnalysis")
	urls := [5]string{
		serviceURL + "GetChannelSessions",
		serviceURL + "GetSessionData",
		serviceURL + "GetCapturedFileDetail",
		serviceURL + "ListCapturedFiles",
		serviceURL + "GetCapturedFileDownloadLink",
	}

	return &carrotStreamAnalysisJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *carrotStreamAnalysisJSONClient) GetChannelSessions(ctx context.Context, in *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	caller := c.callGetChannelSessions
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelSessionsRequest) when calling interceptor")
					}
					return c.callGetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisJSONClient) callGetChannelSessions(ctx context.Context, in *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
	out := new(GetChannelSessionsResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisJSONClient) GetSessionData(ctx context.Context, in *GetSessionDataRequest) (*GetSessionDataResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	caller := c.callGetSessionData
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetSessionDataRequest) (*GetSessionDataResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSessionDataRequest) when calling interceptor")
					}
					return c.callGetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisJSONClient) callGetSessionData(ctx context.Context, in *GetSessionDataRequest) (*GetSessionDataResponse, error) {
	out := new(GetSessionDataResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisJSONClient) GetCapturedFileDetail(ctx context.Context, in *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	caller := c.callGetCapturedFileDetail
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDetailRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisJSONClient) callGetCapturedFileDetail(ctx context.Context, in *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
	out := new(GetCapturedFileDetailResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisJSONClient) ListCapturedFiles(ctx context.Context, in *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "ListCapturedFiles")
	caller := c.callListCapturedFiles
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListCapturedFilesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListCapturedFilesRequest) when calling interceptor")
					}
					return c.callListCapturedFiles(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListCapturedFilesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListCapturedFilesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisJSONClient) callListCapturedFiles(ctx context.Context, in *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
	out := new(ListCapturedFilesResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *carrotStreamAnalysisJSONClient) GetCapturedFileDownloadLink(ctx context.Context, in *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	caller := c.callGetCapturedFileDownloadLink
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return c.callGetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *carrotStreamAnalysisJSONClient) callGetCapturedFileDownloadLink(ctx context.Context, in *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
	out := new(GetCapturedFileDownloadLinkResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===================================
// CarrotStreamAnalysis Server Handler
// ===================================

type carrotStreamAnalysisServer struct {
	CarrotStreamAnalysis
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewCarrotStreamAnalysisServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewCarrotStreamAnalysisServer(svc CarrotStreamAnalysis, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwads compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &carrotStreamAnalysisServer{
		CarrotStreamAnalysis: svc,
		hooks:                serverOpts.Hooks,
		interceptor:          twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:           pathPrefix,
		jsonSkipDefaults:     jsonSkipDefaults,
		jsonCamelCase:        jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *carrotStreamAnalysisServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *carrotStreamAnalysisServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// CarrotStreamAnalysisPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const CarrotStreamAnalysisPathPrefix = "/twirp/starfruit.carrot_stream_analysis.CarrotStreamAnalysis/"

func (s *carrotStreamAnalysisServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "starfruit.carrot_stream_analysis")
	ctx = ctxsetters.WithServiceName(ctx, "CarrotStreamAnalysis")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "starfruit.carrot_stream_analysis.CarrotStreamAnalysis" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "GetChannelSessions":
		s.serveGetChannelSessions(ctx, resp, req)
		return
	case "GetSessionData":
		s.serveGetSessionData(ctx, resp, req)
		return
	case "GetCapturedFileDetail":
		s.serveGetCapturedFileDetail(ctx, resp, req)
		return
	case "ListCapturedFiles":
		s.serveListCapturedFiles(ctx, resp, req)
		return
	case "GetCapturedFileDownloadLink":
		s.serveGetCapturedFileDownloadLink(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *carrotStreamAnalysisServer) serveGetChannelSessions(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetChannelSessionsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetChannelSessionsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotStreamAnalysisServer) serveGetChannelSessionsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetChannelSessionsRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotStreamAnalysis.GetChannelSessions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelSessionsRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelSessionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSessionsResponse and nil error while calling GetChannelSessions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetChannelSessionsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetChannelSessions")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetChannelSessionsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotStreamAnalysis.GetChannelSessions
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetChannelSessionsRequest) (*GetChannelSessionsResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetChannelSessionsRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetChannelSessionsRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetChannelSessions(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetChannelSessionsResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetChannelSessionsResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetChannelSessionsResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetChannelSessionsResponse and nil error while calling GetChannelSessions. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetSessionData(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetSessionDataJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetSessionDataProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotStreamAnalysisServer) serveGetSessionDataJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetSessionDataRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotStreamAnalysis.GetSessionData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSessionDataRequest) (*GetSessionDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSessionDataRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSessionDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSessionDataResponse and nil error while calling GetSessionData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetSessionDataProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetSessionData")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetSessionDataRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotStreamAnalysis.GetSessionData
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetSessionDataRequest) (*GetSessionDataResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetSessionDataRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetSessionDataRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetSessionData(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetSessionDataResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetSessionDataResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetSessionDataResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetSessionDataResponse and nil error while calling GetSessionData. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDetail(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCapturedFileDetailJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCapturedFileDetailProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDetailJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetCapturedFileDetailRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotStreamAnalysis.GetCapturedFileDetail
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDetailRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetCapturedFileDetailResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCapturedFileDetailResponse and nil error while calling GetCapturedFileDetail. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDetailProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDetail")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetCapturedFileDetailRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotStreamAnalysis.GetCapturedFileDetail
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetCapturedFileDetailRequest) (*GetCapturedFileDetailResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDetailRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDetailRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetCapturedFileDetail(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDetailResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDetailResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetCapturedFileDetailResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCapturedFileDetailResponse and nil error while calling GetCapturedFileDetail. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveListCapturedFiles(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListCapturedFilesJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListCapturedFilesProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotStreamAnalysisServer) serveListCapturedFilesJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCapturedFiles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListCapturedFilesRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotStreamAnalysis.ListCapturedFiles
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListCapturedFilesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListCapturedFilesRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.ListCapturedFiles(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListCapturedFilesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListCapturedFilesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListCapturedFilesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCapturedFilesResponse and nil error while calling ListCapturedFiles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveListCapturedFilesProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListCapturedFiles")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListCapturedFilesRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotStreamAnalysis.ListCapturedFiles
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListCapturedFilesRequest) (*ListCapturedFilesResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListCapturedFilesRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListCapturedFilesRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.ListCapturedFiles(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListCapturedFilesResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListCapturedFilesResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListCapturedFilesResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListCapturedFilesResponse and nil error while calling ListCapturedFiles. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDownloadLink(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCapturedFileDownloadLinkJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCapturedFileDownloadLinkProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDownloadLinkJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(GetCapturedFileDownloadLinkRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.CarrotStreamAnalysis.GetCapturedFileDownloadLink
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetCapturedFileDownloadLinkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCapturedFileDownloadLinkResponse and nil error while calling GetCapturedFileDownloadLink. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) serveGetCapturedFileDownloadLinkProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCapturedFileDownloadLink")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(GetCapturedFileDownloadLinkRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.CarrotStreamAnalysis.GetCapturedFileDownloadLink
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *GetCapturedFileDownloadLinkRequest) (*GetCapturedFileDownloadLinkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*GetCapturedFileDownloadLinkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*GetCapturedFileDownloadLinkRequest) when calling interceptor")
					}
					return s.CarrotStreamAnalysis.GetCapturedFileDownloadLink(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*GetCapturedFileDownloadLinkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*GetCapturedFileDownloadLinkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *GetCapturedFileDownloadLinkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCapturedFileDownloadLinkResponse and nil error while calling GetCapturedFileDownloadLink. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *carrotStreamAnalysisServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *carrotStreamAnalysisServer) ProtocGenTwirpVersion() string {
	return "v8.1.0"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *carrotStreamAnalysisServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "starfruit.carrot_stream_analysis", "CarrotStreamAnalysis")
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler

	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// google.golang.org/protobuf/types/descriptorpb.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)

	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string

	// PathPrefix returns the HTTP URL path prefix for all methods handled by this
	// service. This can be used with an HTTP mux to route Twirp requests.
	// The path prefix is in the form: "/<prefix>/<package>.<Service>/"
	// that is, everything in a Twirp route except for the <Method> at the end.
	PathPrefix() string
}

func newServerOpts(opts []interface{}) *twirp.ServerOptions {
	serverOpts := &twirp.ServerOptions{}
	for _, opt := range opts {
		switch o := opt.(type) {
		case twirp.ServerOption:
			o(serverOpts)
		case *twirp.ServerHooks: // backwards compatibility, allow to specify hooks as an argument
			twirp.WithServerHooks(o)(serverOpts)
		case nil: // backwards compatibility, allow nil value for the argument
			continue
		default:
			panic(fmt.Sprintf("Invalid option type %T, please use a twirp.ServerOption", o))
		}
	}
	return serverOpts
}

// WriteError writes an HTTP response with a valid Twirp error format (code, msg, meta).
// Useful outside of the Twirp server (e.g. http middleware), but does not trigger hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Convert to a twirp.Error. Non-twirp errors are converted to internal errors.
	var twerr twirp.Error
	if !errors.As(err, &twerr) {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	respBody := marshalErrorToJSON(twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBody)))
	resp.WriteHeader(statusCode) // set HTTP status code and send response

	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// sanitizeBaseURL parses the the baseURL, and adds the "http" scheme if needed.
// If the URL is unparsable, the baseURL is returned unchaged.
func sanitizeBaseURL(baseURL string) string {
	u, err := url.Parse(baseURL)
	if err != nil {
		return baseURL // invalid URL will fail later when making requests
	}
	if u.Scheme == "" {
		u.Scheme = "http"
	}
	return u.String()
}

// baseServicePath composes the path prefix for the service (without <Method>).
// e.g.: baseServicePath("/twirp", "my.pkg", "MyService")
//       returns => "/twirp/my.pkg.MyService/"
// e.g.: baseServicePath("", "", "MyService")
//       returns => "/MyService/"
func baseServicePath(prefix, pkg, service string) string {
	fullServiceName := service
	if pkg != "" {
		fullServiceName = pkg + "." + service
	}
	return path.Join("/", prefix, fullServiceName) + "/"
}

// parseTwirpPath extracts path components form a valid Twirp route.
// Expected format: "[<prefix>]/<package>.<Service>/<Method>"
// e.g.: prefix, pkgService, method := parseTwirpPath("/twirp/pkg.Svc/MakeHat")
func parseTwirpPath(path string) (string, string, string) {
	parts := strings.Split(path, "/")
	if len(parts) < 2 {
		return "", "", ""
	}
	method := parts[len(parts)-1]
	pkgService := parts[len(parts)-2]
	prefix := strings.Join(parts[0:len(parts)-2], "/")
	return prefix, pkgService, method
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v8.1.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return wrapInternal(err, "failed to read server error response body")
	}

	var tj twerrJSON
	dec := json.NewDecoder(bytes.NewReader(respBodyBytes))
	dec.DisallowUnknownFields()
	if err := dec.Decode(&tj); err != nil || tj.Code == "" {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg).WithMeta("body", string(respBodyBytes))
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429: // Too Many Requests
			code = twirp.ResourceExhausted
		case 502, 503, 504: // Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}

func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrapInternal wraps an error with a prefix as an Internal error.
// The original error cause is accessible by github.com/pkg/errors.Cause.
func wrapInternal(err error, prefix string) twirp.Error {
	return twirp.InternalErrorWith(&wrappedError{prefix: prefix, cause: err})
}

type wrappedError struct {
	prefix string
	cause  error
}

func (e *wrappedError) Error() string { return e.prefix + ": " + e.cause.Error() }
func (e *wrappedError) Unwrap() error { return e.cause } // for go1.13 + errors.Is/As
func (e *wrappedError) Cause() error  { return e.cause } // for github.com/pkg/errors

// ensurePanicResponses makes sure that rpc methods causing a panic still result in a Twirp Internal
// error response (status 500), and error hooks are properly called with the panic wrapped as an error.
// The panic is re-raised so it can be handled normally with middleware.
func ensurePanicResponses(ctx context.Context, resp http.ResponseWriter, hooks *twirp.ServerHooks) {
	if r := recover(); r != nil {
		// Wrap the panic as an error so it can be passed to error hooks.
		// The original error is accessible from error hooks, but not visible in the response.
		err := errFromPanic(r)
		twerr := &internalWithCause{msg: "Internal service panic", cause: err}
		// Actually write the error
		writeError(ctx, resp, twerr, hooks)
		// If possible, flush the error to the wire.
		f, ok := resp.(http.Flusher)
		if ok {
			f.Flush()
		}

		panic(r)
	}
}

// errFromPanic returns the typed error if the recovered panic is an error, otherwise formats as error.
func errFromPanic(p interface{}) error {
	if err, ok := p.(error); ok {
		return err
	}
	return fmt.Errorf("panic: %v", p)
}

// internalWithCause is a Twirp Internal error wrapping an original error cause,
// but the original error message is not exposed on Msg(). The original error
// can be checked with go1.13+ errors.Is/As, and also by (github.com/pkg/errors).Unwrap
type internalWithCause struct {
	msg   string
	cause error
}

func (e *internalWithCause) Unwrap() error                               { return e.cause } // for go1.13 + errors.Is/As
func (e *internalWithCause) Cause() error                                { return e.cause } // for github.com/pkg/errors
func (e *internalWithCause) Error() string                               { return e.msg + ": " + e.cause.Error() }
func (e *internalWithCause) Code() twirp.ErrorCode                       { return twirp.Internal }
func (e *internalWithCause) Msg() string                                 { return e.msg }
func (e *internalWithCause) Meta(key string) string                      { return "" }
func (e *internalWithCause) MetaMap() map[string]string                  { return nil }
func (e *internalWithCause) WithMeta(key string, val string) twirp.Error { return e }

// malformedRequestError is used when the twirp server cannot unmarshal a request
func malformedRequestError(msg string) twirp.Error {
	return twirp.NewError(twirp.Malformed, msg)
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// withoutRedirects makes sure that the POST request can not be redirected.
// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest makes a Protobuf request to the remote Twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal proto request")
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return ctx, wrapInternal(err, "failed to read response body")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal proto response")
	}
	return ctx, nil
}

// doJSONRequest makes a JSON request to the remote Twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, hooks *twirp.ClientHooks, url string, in, out proto.Message) (_ context.Context, err error) {
	marshaler := &protojson.MarshalOptions{UseProtoNames: true}
	reqBytes, err := marshaler.Marshal(in)
	if err != nil {
		return ctx, wrapInternal(err, "failed to marshal json request")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	req, err := newRequest(ctx, url, bytes.NewReader(reqBytes), "application/json")
	if err != nil {
		return ctx, wrapInternal(err, "could not build request")
	}
	ctx, err = callClientRequestPrepared(ctx, hooks, req)
	if err != nil {
		return ctx, err
	}

	req = req.WithContext(ctx)
	resp, err := client.Do(req)
	if err != nil {
		return ctx, wrapInternal(err, "failed to do request")
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = wrapInternal(cerr, "failed to close response body")
		}
	}()

	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}

	if resp.StatusCode != 200 {
		return ctx, errorFromResponse(resp)
	}

	d := json.NewDecoder(resp.Body)
	rawRespBody := json.RawMessage{}
	if err := d.Decode(&rawRespBody); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawRespBody, out); err != nil {
		return ctx, wrapInternal(err, "failed to unmarshal json response")
	}
	if err = ctx.Err(); err != nil {
		return ctx, wrapInternal(err, "aborted because context was done")
	}
	return ctx, nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

func callClientResponseReceived(ctx context.Context, h *twirp.ClientHooks) {
	if h == nil || h.ResponseReceived == nil {
		return
	}
	h.ResponseReceived(ctx)
}

func callClientRequestPrepared(ctx context.Context, h *twirp.ClientHooks, req *http.Request) (context.Context, error) {
	if h == nil || h.RequestPrepared == nil {
		return ctx, nil
	}
	return h.RequestPrepared(ctx, req)
}

func callClientError(ctx context.Context, h *twirp.ClientHooks, err twirp.Error) {
	if h == nil || h.Error == nil {
		return
	}
	h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 2576 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x5b, 0x6f, 0x23, 0xb7,
	0xf5, 0x87, 0xac, 0xb5, 0x2c, 0x1d, 0xc9, 0xb6, 0xcc, 0xbd, 0x64, 0x56, 0xb9, 0x6d, 0x14, 0x24,
	0xf1, 0xfe, 0x93, 0xb5, 0xf3, 0x77, 0xae, 0x4d, 0x82, 0x06, 0xbb, 0xf6, 0x7a, 0xe3, 0xc6, 0xbb,
	0x6b, 0x8c, 0xdd, 0xf4, 0x82, 0x04, 0x03, 0x6a, 0x86, 0x92, 0x59, 0x8f, 0x86, 0x53, 0x92, 0x72,
	0xd6, 0x79, 0x2d, 0xfa, 0xd4, 0xa0, 0x7d, 0xed, 0x07, 0x68, 0x5e, 0x8a, 0x3e, 0x05, 0xe8, 0x6b,
	0xbf, 0x44, 0x3f, 0x43, 0xbf, 0x47, 0xc1, 0x43, 0x72, 0x24, 0x59, 0x72, 0x24, 0x3b, 0x41, 0x9f,
	0x3c, 0xfc, 0x9d, 0x0b, 0xc9, 0xc3, 0x73, 0x95, 0xe1, 0x85, 0x98, 0x4a, 0x29, 0x74, 0xa4, 0xb4,
	0x64, 0xb4, 0x1f, 0xd1, 0x8c, 0xa6, 0x67, 0x8a, 0xab, 0x8d, 0x5c, 0x0a, 0x2d, 0xc8, 0x1d, 0xa5,
	0xa9, 0xec, 0xca, 0x01, 0xd7, 0x1b, 0xd3, 0xf9, 0x5a, 0x2f, 0xf7, 0x84, 0xe8, 0xa5, 0x6c, 0x13,
	0xf9, 0x3b, 0x83, 0xee, 0xa6, 0xe6, 0x7d, 0xa6, 0x34, 0xed, 0xe7, 0x56, 0x45, 0xeb, 0xa5, 0xf3,
	0x0c, 0xc9, 0x40, 0x52, 0xcd, 0x45, 0x66, 0xe9, 0xed, 0xef, 0x17, 0xa0, 0x7e, 0xc8, 0x94, 0xe2,
	0x22, 0xdb, 0xcb, 0xba, 0x82, 0xbc, 0x08, 0xa0, 0xec, 0x32, 0xe2, 0x49, 0x50, 0xba, 0x53, 0x5a,
	0xaf, 0x85, 0x35, 0x87, 0xec, 0x25, 0xe4, 0x6d, 0x58, 0x34, 0x67, 0xd2, 0xc1, 0xc2, 0x9d, 0xd2,
	0x7a, 0x7d, 0xab, 0xb5, 0x61, 0xd5, 0x6f, 0x78, 0xf5, 0x1b, 0x47, 0x7e, 0xff, 0xd0, 0x32, 0x92,
	0xb7, 0xa0, 0xcc, 0xb2, 0x24, 0x28, 0xcf, 0xe4, 0x37, 0x6c, 0xe4, 0x65, 0xa8, 0xf3, 0xac, 0xc7,
	0x94, 0x8e, 0x58, 0xd2, 0x63, 0xc1, 0x35, 0xdc, 0x1f, 0x2c, 0xf4, 0x30, 0xe9, 0x31, 0x72, 0x17,
	0x9a, 0x1d, 0x29, 0x68, 0x12, 0x53, 0xa5, 0xa3, 0xae, 0x90, 0x7d, 0xaa, 0x83, 0x45, 0xe4, 0x5a,
	0x2d, 0xf0, 0x5d, 0x84, 0xc9, 0xaf, 0xa1, 0x29, 0x59, 0x4a, 0x35, 0x4b, 0x22, 0x77, 0x01, 0x15,
	0x54, 0xee, 0x94, 0xd7, 0xeb, 0x5b, 0xf7, 0x36, 0x66, 0x19, 0x76, 0x63, 0xc4, 0x26, 0xe1, 0xaa,
	0x53, 0xe3, 0x30, 0xd5, 0xfe, 0x77, 0x09, 0x6e, 0x3f, 0x62, 0x7a, 0xfb, 0x98, 0x66, 0x19, 0x4b,
	0x3d, 0x1c, 0xb2, 0xdf, 0x0f, 0x98, 0xd2, 0xe6, 0x0e, 0xf1, 0x40, 0x69, 0xd1, 0x67, 0x72, 0x68,
	0x43, 0xf0, 0xd0, 0x5e, 0x62, 0x6c, 0x1c, 0x8b, 0x4c, 0xb3, 0x4c, 0x1b, 0xfa, 0x82, 0xb5, 0xb1,
	0x43, 0x46, 0x6d, 0x5c, 0xbe, 0xa4, 0x8d, 0xaf, 0xcd, 0x67, 0xe3, 0x5b, 0x50, 0x91, 0xac, 0xc7,
	0x45, 0xe6, 0x0c, 0xe7, 0x56, 0xed, 0x1e, 0xb4, 0xa6, 0x5d, 0x4a, 0xe5, 0x22, 0x53, 0x8c, 0xec,
	0x41, 0xb5, 0xb0, 0x62, 0xe9, 0x2a, 0x56, 0x2c, 0xc4, 0xdb, 0xff, 0xa8, 0xc0, 0x92, 0xa3, 0xcc,
	0xf2, 0xb7, 0x2f, 0x60, 0xc5, 0xf9, 0x83, 0xc3, 0x02, 0xc0, 0x4b, 0x6e, 0xce, 0xde, 0x7b, 0x0f,
	0xe5, 0xdc, 0x3e, 0xe1, 0x32, 0x1f, 0x5d, 0x4e, 0xf5, 0x8d, 0xd5, 0x9f, 0xc2, 0x37, 0xc8, 0x01,
	0x34, 0xa4, 0xee, 0xe7, 0xc5, 0x79, 0x6f, 0xe0, 0x79, 0xe7, 0xd0, 0x1a, 0x1e, 0x3d, 0x3e, 0xf0,
	0xa7, 0xad, 0x1b, 0x15, 0xfe, 0xac, 0x1c, 0x6e, 0x76, 0x68, 0x7c, 0x32, 0xc8, 0xa3, 0x73, 0xa6,
	0x78, 0x09, 0x55, 0xbf, 0x37, 0x5b, 0xf5, 0x03, 0x14, 0x1f, 0x37, 0xc8, 0xf5, 0xce, 0x24, 0x48,
	0x28, 0x10, 0x2d, 0x69, 0xa6, 0x62, 0x91, 0xb0, 0xa1, 0x61, 0xd6, 0xd1, 0x30, 0x5b, 0xb3, 0xf7,
	0x39, 0xf2, 0xb2, 0x7e, 0x93, 0x35, 0x7d, 0x0e, 0x51, 0x64, 0x1f, 0xea, 0x5d, 0x49, 0xfb, 0x2c,
	0x4a, 0xa4, 0xc8, 0x55, 0xb0, 0x85, 0xba, 0xdf, 0x9c, 0xad, 0x7b, 0xd7, 0x08, 0xed, 0x48, 0x91,
	0x87, 0xd0, 0xf5, 0x9f, 0x8a, 0x3c, 0x81, 0xba, 0x91, 0x3c, 0xc5, 0x94, 0xa6, 0x82, 0x4f, 0x50,
	0xdb, 0x5b, 0x73, 0x3c, 0x61, 0x21, 0x14, 0x8e, 0x2a, 0x20, 0x9f, 0x83, 0xd5, 0x2e, 0xa9, 0x66,
	0x2a, 0xd8, 0xbd, 0xd4, 0xe1, 0x8c, 0x4c, 0x38, 0x22, 0x4e, 0x1e, 0x42, 0xb5, 0xc3, 0xb5, 0x55,
	0x75, 0x80, 0xaa, 0xee, 0xce, 0xf1, 0x56, 0x56, 0x22, 0x2c, 0x44, 0xdb, 0x1d, 0x58, 0x72, 0x20,
	0xf9, 0x10, 0x6a, 0x45, 0x82, 0xc7, 0x60, 0xf9, 0xe1, 0x70, 0x1f, 0x32, 0x9b, 0x38, 0x3b, 0xa5,
	0xe9, 0x80, 0x45, 0x27, 0x9d, 0x5c, 0x61, 0xce, 0x59, 0x08, 0x6b, 0x88, 0x7c, 0xde, 0xc9, 0xcd,
	0x1e, 0xb5, 0xe2, 0x0e, 0x3f, 0x62, 0x97, 0xe7, 0xc1, 0xea, 0x8c, 0xba, 0xc5, 0x26, 0x55, 0x04,
	0x76, 0x73, 0xd5, 0x8e, 0xa1, 0xb2, 0x77, 0x80, 0x45, 0x26, 0x80, 0xa5, 0x58, 0x0c, 0x32, 0x2d,
	0xcf, 0x5c, 0xc4, 0xfb, 0x25, 0x21, 0x70, 0x2d, 0xe6, 0xfa, 0xcc, 0x25, 0x45, 0xfc, 0x26, 0x4d,
	0x28, 0x53, 0x95, 0x61, 0x36, 0x5c, 0x0e, 0xcd, 0x27, 0xb9, 0x0d, 0x55, 0xae, 0xf2, 0x28, 0xa3,
	0x7d, 0x5f, 0x22, 0x96, 0xb8, 0xca, 0x9f, 0xd0, 0x3e, 0x6b, 0xff, 0xb3, 0x02, 0xf5, 0x91, 0x48,
	0x22, 0xaf, 0x40, 0x83, 0x0e, 0x12, 0x2e, 0x22, 0xe3, 0x84, 0xb1, 0x72, 0x8a, 0xeb, 0x88, 0x6d,
	0x23, 0x64, 0x58, 0x4e, 0x79, 0xc2, 0x0a, 0x96, 0xb2, 0x65, 0x41, 0xcc, 0xb1, 0xbc, 0x0f, 0xcf,
	0x59, 0x16, 0xc9, 0x94, 0x48, 0x07, 0xc6, 0x57, 0xa2, 0x63, 0xc6, 0x7b, 0xc7, 0x1a, 0xf7, 0x2f,
	0x87, 0x37, 0x91, 0x1c, 0x16, 0xd4, 0xcf, 0x90, 0x48, 0xde, 0x85, 0x5b, 0x13, 0x72, 0x5f, 0xf3,
	0x44, 0x1f, 0x63, 0xea, 0x2d, 0x87, 0x37, 0xce, 0x89, 0xfd, 0xca, 0xd0, 0x8c, 0x15, 0xe9, 0x69,
	0x1c, 0xa5, 0xec, 0x94, 0xa5, 0x41, 0x05, 0x19, 0xab, 0xf4, 0x34, 0xde, 0x37, 0x6b, 0x73, 0x5a,
	0x9e, 0xc8, 0x88, 0x67, 0x9a, 0xc9, 0x53, 0x9a, 0x06, 0x4b, 0x48, 0xaf, 0xf3, 0x44, 0xee, 0x39,
	0xc8, 0xd4, 0x48, 0xc5, 0x7a, 0x7d, 0x53, 0x5f, 0x7c, 0xb5, 0x0f, 0xaa, 0xc8, 0xb6, 0xea, 0xf0,
	0x1d, 0x07, 0x93, 0x57, 0x61, 0x19, 0xb3, 0x55, 0x9f, 0x69, 0x9a, 0x50, 0x4d, 0x83, 0x1a, 0x5e,
	0x1e, 0x53, 0xd8, 0x63, 0x87, 0x19, 0xdf, 0x41, 0xa6, 0x6e, 0x4a, 0x7b, 0x0a, 0x13, 0x70, 0x2d,
	0xac, 0x19, 0x64, 0xd7, 0x00, 0x64, 0x1d, 0x9a, 0x48, 0x66, 0xcf, 0xb8, 0x8e, 0x24, 0xa3, 0x4a,
	0x64, 0x41, 0x1d, 0x99, 0x56, 0x0c, 0xfe, 0xf0, 0x19, 0xd7, 0x21, 0xa2, 0xe6, 0xdd, 0x59, 0x66,
	0xac, 0x2c, 0x83, 0x86, 0x7d, 0x36, 0xb7, 0x34, 0x57, 0x8e, 0x53, 0x8e, 0x15, 0x31, 0x0f, 0x96,
	0x91, 0x56, 0xb5, 0xc0, 0x5e, 0x4e, 0x5e, 0x87, 0x55, 0x6b, 0x45, 0x73, 0x9a, 0xc8, 0xb8, 0x68,
	0xb0, 0x82, 0xd7, 0x59, 0x46, 0x78, 0x87, 0x6a, 0x1a, 0x1a, 0xbf, 0x5d, 0x87, 0xa6, 0xe5, 0xb3,
	0x09, 0x06, 0x19, 0x57, 0x91, 0x71, 0x05, 0x71, 0xf4, 0x70, 0xe4, 0xfc, 0x3f, 0x58, 0xb3, 0x5e,
	0xa1, 0x68, 0x3f, 0x4f, 0x1d, 0x6b, 0xd3, 0x9a, 0x08, 0x09, 0x87, 0x88, 0x23, 0xef, 0xeb, 0x60,
	0xa1, 0x91, 0xdd, 0xd7, 0xec, 0xee, 0x08, 0x17, 0xbb, 0xbf, 0x06, 0x2b, 0xce, 0xd3, 0x6c, 0x05,
	0x55, 0x01, 0x19, 0x61, 0x73, 0x65, 0x55, 0x0d, 0xd5, 0x71, 0x15, 0x29, 0xcd, 0x24, 0x13, 0xc1,
	0xf5, 0x3b, 0xa5, 0xf5, 0xaa, 0xe3, 0xdb, 0x53, 0x87, 0x08, 0x4e, 0x1c, 0x51, 0xf1, 0x6f, 0x18,
	0x16, 0x93, 0xf1, 0x23, 0x1e, 0xf2, 0x6f, 0x18, 0xb9, 0x0f, 0x4b, 0xdc, 0x54, 0x87, 0xae, 0x08,
	0x6e, 0x62, 0xb8, 0xae, 0xcf, 0x51, 0x1e, 0x31, 0x14, 0xc3, 0x0a, 0xcf, 0xcd, 0xdf, 0xf6, 0x7f,
	0x16, 0xa0, 0x79, 0x3e, 0x7d, 0x9b, 0x68, 0x3c, 0x16, 0x4a, 0xfb, 0x68, 0x34, 0xdf, 0xe6, 0x0d,
	0x73, 0x29, 0xba, 0x3c, 0x65, 0x2e, 0x50, 0xfc, 0xd2, 0xf8, 0x92, 0xd2, 0x34, 0x3e, 0x89, 0x4e,
	0x99, 0xc4, 0xfa, 0x64, 0x43, 0xa3, 0x81, 0xe0, 0x17, 0x16, 0x33, 0x4c, 0xae, 0x8a, 0x09, 0xc9,
	0x7b, 0xdc, 0xf7, 0x20, 0x0d, 0x0b, 0x3e, 0x45, 0x6c, 0x22, 0x68, 0x2b, 0xb3, 0x83, 0x76, 0x69,
	0x32, 0x68, 0xc7, 0xd2, 0x58, 0xf5, 0x32, 0x69, 0xec, 0xae, 0xe9, 0x0e, 0x62, 0x21, 0x13, 0x9e,
	0xf5, 0xa2, 0x5c, 0xb2, 0x2e, 0x7f, 0xe6, 0x02, 0x63, 0xb5, 0xc0, 0x0f, 0x10, 0x26, 0x1b, 0x70,
	0x7d, 0xc8, 0xaa, 0xde, 0x89, 0x3a, 0x83, 0xf8, 0x84, 0x69, 0x17, 0x24, 0x6b, 0x05, 0xe9, 0xf0,
	0x9d, 0x07, 0x48, 0x68, 0x7f, 0xb7, 0x00, 0xcb, 0xe3, 0x35, 0xf7, 0x03, 0xa8, 0xb9, 0xb7, 0x19,
	0xe4, 0x73, 0xb4, 0xd5, 0x55, 0xcb, 0xfc, 0xcb, 0x9c, 0x7c, 0x6c, 0x6a, 0x1f, 0x0a, 0x26, 0xe2,
	0xeb, 0x6c, 0x8e, 0x6e, 0x11, 0x2c, 0xfb, 0x8e, 0xf8, 0x3a, 0x1b, 0x69, 0xb4, 0xf1, 0x85, 0xc7,
	0x1a, 0xed, 0xcf, 0xcc, 0x3b, 0x6f, 0xc2, 0x62, 0xc2, 0x52, 0x7a, 0x86, 0x0f, 0x54, 0xdf, 0xba,
	0x3d, 0xa1, 0xd7, 0xe7, 0x90, 0xd0, 0xf2, 0x4d, 0xed, 0xcc, 0x2b, 0xd3, 0x3b, 0x73, 0x93, 0xc3,
	0xec, 0xe6, 0xb9, 0x14, 0xcf, 0xce, 0xfc, 0xe3, 0x59, 0xec, 0xc0, 0x40, 0xed, 0x6f, 0xcb, 0x70,
	0x7d, 0x4a, 0xdb, 0x42, 0x8e, 0x8d, 0x93, 0x71, 0x1d, 0x1f, 0xb3, 0x24, 0xea, 0x4a, 0xd1, 0x0f,
	0x16, 0xb0, 0xb0, 0x6e, 0x5f, 0xa9, 0x09, 0x72, 0x98, 0xef, 0x56, 0x1a, 0x5e, 0xf3, 0xae, 0x14,
	0x7d, 0x92, 0x18, 0xf3, 0xba, 0x9d, 0xb4, 0x08, 0xca, 0x3f, 0xdd, 0x3e, 0xe0, 0xf5, 0x1e, 0x89,
	0xd6, 0xdf, 0x4a, 0xb0, 0x3c, 0x46, 0x9d, 0xd5, 0x11, 0x4f, 0x33, 0xf3, 0xc2, 0x74, 0x33, 0xef,
	0x01, 0x19, 0xde, 0xa0, 0x88, 0x84, 0xd9, 0x7e, 0xb2, 0x56, 0x9c, 0xcf, 0x43, 0x6d, 0xed, 0xfa,
	0x03, 0xd3, 0x75, 0x0d, 0x07, 0x94, 0xd2, 0xbc, 0x03, 0xca, 0x7b, 0x50, 0x2d, 0x2a, 0xd1, 0xc2,
	0x2c, 0x7f, 0x2a, 0x58, 0xdb, 0x03, 0x80, 0x61, 0xa3, 0xf6, 0xbf, 0xdb, 0xf6, 0xcf, 0x25, 0xb8,
	0xf9, 0x88, 0xf9, 0xc7, 0xc3, 0x04, 0xff, 0x13, 0x8d, 0x76, 0xe3, 0x6f, 0x5b, 0x3e, 0xff, 0xb6,
	0xc3, 0xc9, 0xec, 0xda, 0xd8, 0x64, 0xf6, 0x15, 0xdc, 0x3a, 0x7f, 0x1e, 0x37, 0x95, 0x6d, 0xc3,
	0x92, 0x9f, 0x06, 0xac, 0x55, 0xee, 0xce, 0x3d, 0xbe, 0x84, 0x5e, 0xb2, 0xfd, 0x36, 0xbc, 0x60,
	0x06, 0x3f, 0x9a, 0xeb, 0x81, 0x64, 0xc9, 0x2e, 0x4f, 0xd9, 0x0e, 0xd3, 0x94, 0xa7, 0xfe, 0xd6,
	0x4d, 0x28, 0x9f, 0x30, 0xdf, 0xaa, 0x99, 0xcf, 0xf6, 0xbf, 0xca, 0x40, 0x26, 0xf9, 0x4d, 0xbd,
	0xc0, 0x32, 0x55, 0xc2, 0xc4, 0x8f, 0xdf, 0xa4, 0x75, 0xee, 0x0d, 0x4a, 0x43, 0x43, 0x93, 0x37,
	0x60, 0x55, 0x9c, 0x32, 0x49, 0xd3, 0x34, 0x72, 0xdd, 0x2e, 0xda, 0xa4, 0x1c, 0xae, 0x38, 0xd8,
	0xf7, 0xbd, 0x2f, 0x40, 0xad, 0xe8, 0xab, 0xd1, 0x36, 0xa5, 0x70, 0x08, 0x98, 0xba, 0x9f, 0x0d,
	0xfa, 0x91, 0xad, 0x07, 0x5a, 0xd2, 0xf8, 0x44, 0x61, 0xd6, 0x5a, 0x0c, 0x57, 0xb2, 0x41, 0xff,
	0x0b, 0x03, 0x1f, 0x21, 0xea, 0x39, 0x6d, 0x71, 0x71, 0x9c, 0x95, 0x82, 0xf3, 0xbe, 0x81, 0x1d,
	0xe7, 0x97, 0xbe, 0xbe, 0x24, 0x78, 0x35, 0x4c, 0x51, 0xf5, 0xad, 0x9f, 0xcd, 0xb6, 0xee, 0xa8,
	0x59, 0x70, 0x6b, 0x67, 0x4b, 0x5b, 0x9a, 0x9c, 0xa1, 0xbe, 0xf4, 0x05, 0xce, 0x69, 0xaf, 0x5e,
	0x45, 0x3b, 0x1e, 0xd7, 0x6b, 0xa7, 0xc3, 0x85, 0x49, 0xaf, 0x31, 0xcd, 0xb0, 0x2a, 0xa4, 0x82,
	0x26, 0x58, 0xba, 0xaa, 0x61, 0x3d, 0xa6, 0xd9, 0x8e, 0x83, 0xda, 0xdf, 0x55, 0xe1, 0xb9, 0x0b,
	0x4e, 0x6a, 0xbc, 0xd0, 0xe5, 0x15, 0xfb, 0xe2, 0x6e, 0x35, 0x5a, 0xf9, 0x17, 0xc6, 0x2b, 0xff,
	0x0d, 0x58, 0xb4, 0xcd, 0x6a, 0x19, 0x9f, 0xc6, 0x2e, 0x0c, 0x1a, 0xd3, 0x0e, 0x8d, 0xf1, 0xc1,
	0xaa, 0xa1, 0x5d, 0x60, 0x33, 0xc9, 0xba, 0xb6, 0x45, 0xf3, 0xcf, 0x54, 0x93, 0xac, 0x8b, 0xe9,
	0x45, 0x99, 0xd6, 0x1e, 0x2b, 0xba, 0x89, 0x0f, 0xfb, 0x32, 0x4b, 0xb8, 0xde, 0x4b, 0xcc, 0xfe,
	0xde, 0x4b, 0x6c, 0xd3, 0xeb, 0x97, 0xc6, 0x8f, 0xdc, 0x67, 0x94, 0x89, 0x3e, 0xcf, 0x68, 0xea,
	0xfa, 0xdd, 0x15, 0x07, 0x3f, 0xb1, 0xa8, 0x39, 0x92, 0x6d, 0xbf, 0x6b, 0xa8, 0xda, 0x2e, 0x4c,
	0x4f, 0x82, 0x1f, 0xae, 0xd5, 0x4a, 0xb0, 0x7a, 0x2f, 0x86, 0x0d, 0x04, 0x6d, 0x9b, 0x85, 0xb1,
	0xe9, 0x3a, 0xfe, 0x3a, 0x52, 0xdd, 0xca, 0xb4, 0x7d, 0xf6, 0xab, 0x90, 0x6e, 0x20, 0x7d, 0xd9,
	0xa2, 0x5e, 0xfc, 0x2d, 0x20, 0x39, 0x7f, 0xc6, 0xd2, 0x88, 0xaa, 0x9c, 0xc5, 0x3a, 0xc2, 0x08,
	0xc0, 0x4e, 0xb7, 0x14, 0x36, 0x91, 0x72, 0x1f, 0x09, 0xa1, 0xc1, 0xc9, 0xdb, 0x70, 0x23, 0xe1,
	0x2a, 0x4f, 0xe9, 0xd9, 0x38, 0xff, 0x0a, 0xf2, 0x13, 0x47, 0x1b, 0x95, 0x78, 0x0d, 0x56, 0x8a,
	0x80, 0x88, 0xfa, 0x22, 0xb1, 0x9d, 0x6f, 0x2d, 0x5c, 0x2e, 0xd0, 0xc7, 0x22, 0x61, 0x66, 0x90,
	0x19, 0x67, 0x73, 0x6d, 0x18, 0x4d, 0xb1, 0xfd, 0xad, 0x85, 0x37, 0xc7, 0xf8, 0x9f, 0x3a, 0x22,
	0xb9, 0x07, 0x64, 0x28, 0x57, 0x88, 0xac, 0xe1, 0x71, 0xd6, 0x0a, 0x4a, 0xc1, 0x3e, 0x16, 0xaf,
	0xe4, 0x7c, 0xbc, 0xbe, 0xec, 0x7f, 0x02, 0xc0, 0xa9, 0x0f, 0xdb, 0xdf, 0xb2, 0x1b, 0x9c, 0xb7,
	0x0d, 0x82, 0x0e, 0x2c, 0x52, 0x31, 0x90, 0x91, 0xca, 0x69, 0x6c, 0xdb, 0xde, 0x5a, 0x58, 0xb7,
	0xd8, 0xa1, 0x81, 0xcc, 0x81, 0xe2, 0x63, 0x29, 0xfa, 0x34, 0x52, 0x83, 0x0e, 0x5a, 0x9e, 0x67,
	0x3d, 0xec, 0x7e, 0x6b, 0xe1, 0x9a, 0xa5, 0x1c, 0x0e, 0x09, 0x66, 0xbe, 0xe8, 0x70, 0x1d, 0x25,
	0x2c, 0xd7, 0xc7, 0xc1, 0x2d, 0x7c, 0x20, 0x33, 0x60, 0xef, 0x98, 0xb5, 0x21, 0x2a, 0x13, 0x30,
	0xfa, 0x2c, 0x67, 0xc1, 0x73, 0x76, 0xf8, 0x30, 0xc0, 0xd1, 0x59, 0x8e, 0xbe, 0x6d, 0xfb, 0xa0,
	0xc0, 0xfa, 0xb6, 0x6d, 0x76, 0xde, 0x80, 0x55, 0x37, 0xba, 0x44, 0x29, 0xef, 0x48, 0x2a, 0xcf,
	0x82, 0xdb, 0x76, 0xe4, 0x71, 0xf0, 0xbe, 0x45, 0xc9, 0x19, 0x34, 0x3d, 0xa3, 0x62, 0x5a, 0xf3,
	0xac, 0xa7, 0x82, 0x16, 0xb6, 0x12, 0x4f, 0xae, 0x9c, 0x4b, 0x36, 0x1e, 0x5a, 0x8d, 0x87, 0x4e,
	0xe1, 0x43, 0x33, 0x3a, 0x87, 0xfe, 0x40, 0x1e, 0x6d, 0x3d, 0x80, 0x1b, 0xd3, 0x18, 0x27, 0xd3,
	0xb9, 0xb9, 0x23, 0x4e, 0xe9, 0x2e, 0xae, 0xed, 0xe2, 0xa3, 0x85, 0x0f, 0x4b, 0xed, 0x3f, 0x5d,
	0x1b, 0xcf, 0x13, 0x23, 0x39, 0xe7, 0xc2, 0x3c, 0xd1, 0x84, 0xb2, 0xea, 0x48, 0xa7, 0xcb, 0x7c,
	0x92, 0x4d, 0xb8, 0x4e, 0x93, 0x84, 0x9b, 0x9c, 0x4f, 0xd3, 0xa8, 0xcb, 0xa8, 0xd1, 0xe7, 0x07,
	0x6d, 0x32, 0x24, 0xed, 0x3a, 0xca, 0x58, 0x16, 0xb8, 0xe6, 0x7f, 0x21, 0x98, 0xc8, 0x02, 0x8b,
	0xe3, 0x59, 0xa0, 0x05, 0xd5, 0x62, 0xf4, 0xb2, 0xa9, 0xa3, 0x58, 0x93, 0x37, 0x61, 0xcd, 0x7d,
	0x47, 0xb9, 0x50, 0xdc, 0xfe, 0x5a, 0x64, 0xdb, 0xce, 0xa6, 0x23, 0x1c, 0x78, 0xdc, 0xc4, 0x92,
	0x67, 0x4e, 0xe9, 0x99, 0x18, 0x68, 0xcc, 0x26, 0xb5, 0x70, 0xd9, 0xa1, 0xfb, 0x08, 0x9a, 0x09,
	0xcd, 0x86, 0xbc, 0x8a, 0x72, 0x26, 0x6d, 0x46, 0x73, 0x89, 0x65, 0xd5, 0x11, 0x0e, 0x98, 0xc4,
	0xbc, 0x66, 0x5c, 0x7e, 0x74, 0xd4, 0xb4, 0x09, 0x06, 0xd4, 0x70, 0xca, 0x7c, 0x05, 0x1a, 0x8e,
	0xc1, 0x06, 0x45, 0xdd, 0x8e, 0xf5, 0x16, 0xb3, 0x51, 0x31, 0x16, 0x54, 0x8d, 0xf3, 0x41, 0x75,
	0x17, 0x9a, 0xb1, 0xe8, 0xe7, 0xd2, 0xb5, 0x17, 0x98, 0x02, 0xec, 0x20, 0xbd, 0x3a, 0x82, 0x63,
	0x12, 0x28, 0x5c, 0x7a, 0x65, 0xd4, 0xa5, 0x5f, 0x81, 0x06, 0x7e, 0x44, 0x4a, 0x0c, 0x64, 0xec,
	0xf3, 0x47, 0x1d, 0xb1, 0x43, 0x84, 0xda, 0xbf, 0x81, 0xd5, 0x51, 0x67, 0x78, 0xf4, 0xf4, 0x80,
	0xec, 0x42, 0xc5, 0xa5, 0x72, 0xfb, 0xa3, 0xf0, 0xc6, 0x6c, 0xaf, 0x7e, 0xf4, 0x14, 0x47, 0x4f,
	0x3b, 0x8d, 0x3b, 0xe9, 0xf6, 0x57, 0xd0, 0x18, 0xc5, 0xcd, 0x65, 0xc7, 0x7f, 0x83, 0x2a, 0x9f,
	0xfb, 0x9d, 0x29, 0xe7, 0xb1, 0xb6, 0x11, 0x6b, 0x1d, 0xad, 0x6a, 0x00, 0x8c, 0x58, 0xdf, 0x85,
	0x94, 0x87, 0x5d, 0x48, 0xfb, 0xfb, 0x12, 0xbc, 0x78, 0x41, 0x8f, 0xe3, 0x3a, 0xa9, 0x7d, 0xa8,
	0xb8, 0x62, 0x6c, 0x1b, 0xa9, 0x77, 0x2f, 0x17, 0x9e, 0x4e, 0x9b, 0xd3, 0x41, 0xb6, 0xa1, 0xdc,
	0x13, 0x7e, 0x9c, 0xfb, 0xff, 0xcb, 0xa9, 0x7a, 0xf4, 0xf4, 0x20, 0x34, 0xd2, 0xed, 0x33, 0x68,
	0x8e, 0xe2, 0xf8, 0xd3, 0xd9, 0x64, 0xf0, 0x7e, 0x0a, 0xcb, 0xa9, 0x99, 0x05, 0xfa, 0x22, 0xe1,
	0x5d, 0xce, 0x92, 0x39, 0x66, 0xc8, 0x86, 0x11, 0x78, 0xec, 0xf8, 0xa7, 0xda, 0x6b, 0x0b, 0x82,
	0x7d, 0xae, 0xc6, 0xec, 0x55, 0xfc, 0x7f, 0xe3, 0x16, 0x54, 0xdc, 0x4c, 0xec, 0xe2, 0xde, 0xae,
	0xda, 0x0c, 0x6e, 0x4f, 0x91, 0x71, 0xe6, 0xfd, 0x0c, 0x16, 0x4d, 0xab, 0xe0, 0xdd, 0x64, 0xeb,
	0x72, 0x26, 0xc1, 0x9f, 0x2a, 0xac, 0x82, 0xf6, 0xfb, 0xd0, 0x3e, 0xff, 0x92, 0xae, 0xab, 0xd9,
	0xe7, 0xd9, 0xc9, 0xc5, 0x3d, 0xeb, 0x2f, 0xe0, 0xd5, 0x1f, 0x94, 0x73, 0x07, 0x7d, 0x15, 0x96,
	0x7d, 0xe3, 0x14, 0xa5, 0x3c, 0x3b, 0x71, 0x2a, 0x1a, 0xc9, 0x08, 0xf3, 0xd6, 0x1f, 0x2b, 0x70,
	0x63, 0x1b, 0x8f, 0x7d, 0x88, 0xa7, 0xbe, 0xef, 0x0e, 0x4d, 0xfe, 0x52, 0x02, 0x32, 0xf9, 0x4f,
	0x14, 0xf2, 0xf1, 0x1c, 0x51, 0x71, 0xd1, 0xff, 0x93, 0x5a, 0x9f, 0x5c, 0x4d, 0xd8, 0xdd, 0xe7,
	0x0f, 0x25, 0x58, 0x19, 0x1f, 0x1e, 0xc8, 0x07, 0x73, 0x29, 0x9c, 0x1c, 0x7f, 0x5a, 0x1f, 0x5e,
	0x5e, 0xd0, 0x9d, 0xe2, 0xaf, 0x76, 0xa4, 0x9a, 0x32, 0x33, 0xfc, 0x7c, 0xbe, 0xdb, 0x5d, 0x34,
	0x9c, 0xb4, 0x3e, 0xbd, 0xb2, 0xbc, 0x3b, 0xda, 0xb7, 0x25, 0x58, 0x9b, 0xf0, 0x5b, 0xf2, 0xd1,
	0x6c, 0xb5, 0x17, 0x05, 0x48, 0xeb, 0xe3, 0x2b, 0xc9, 0xba, 0xe3, 0xfc, 0xbd, 0x04, 0xcf, 0xff,
	0x80, 0x9f, 0x92, 0x9d, 0xcb, 0xdf, 0x77, 0x32, 0x3c, 0x5a, 0x0f, 0x7f, 0xa4, 0x16, 0x7b, 0xd8,
	0x07, 0xf7, 0x7f, 0xfb, 0xa9, 0xa9, 0xcb, 0x1b, 0xbf, 0x1b, 0x28, 0xcd, 0xb3, 0x0d, 0x7d, 0xba,
	0xc9, 0x4e, 0x59, 0xa6, 0xef, 0xb1, 0xac, 0xc7, 0x33, 0xc6, 0x24, 0xcf, 0x7a, 0x9b, 0x56, 0xfd,
	0x3d, 0xab, 0xfe, 0x9e, 0x57, 0xbf, 0x99, 0x9f, 0xf4, 0x36, 0x65, 0x1e, 0x77, 0x2a, 0x98, 0x9f,
	0xde, 0xf9, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x1f, 0xb3, 0xb9, 0x0a, 0x1f, 0x00, 0x00,
}
