#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';
import { CarrotSystemHealthStack } from '../lib/carrot-system-health-stack';

const app = new cdk.App();
new CarrotSystemHealthStack(app, 'carrot-system-health-stg', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
  },
  vpcId: 'vpc-0ba8a2483a591a259',
  cshProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::134277936734:role/carrot-control-stg-CarrotControlServiceRole38F61F3-CUOBT9HTOPF4' // Carrot Control
    ],
    omenHost: 'http://omen.us-west-2.prod.gns.justin.tv/api/plyql/v1/query',
    druidBroker: 'druid-broker-0-9-0-rc3.us-west-2.prod.gns.justin.tv:8082',
    omenAppName: 'Carrot-stg',
    broodAPIURL: 'http://alb.us-west-2.prod.brood.live-video.a2z.com',
    liveProxyAPIURL: 'us-west-2.beta.liveproxyapi.live-video-ext.a2z.com',
    liveProxyAPIARN: 'arn:aws:execute-api:us-west-2:599437981448:*/*/*/*',
    originDCs: 'sjc02,cmh01,lhr05,pdx05',
  }
});

new CarrotSystemHealthStack(app, 'carrot-system-health-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  vpcId: 'vpc-094f73121cb30db65',
  cshProps: {
    invokeFunctionRoles: [
      'arn:aws:iam::782947612856:role/carrot-control-prod-CarrotControlServiceRole38F61F-1IQPIF0KPHJF9' // Carrot Control
    ],
    omenHost: 'http://omen.us-west-2.prod.gns.justin.tv/api/plyql/v1/query',
    druidBroker: 'druid-broker-0-9-0-rc3.us-west-2.prod.gns.justin.tv:8082',
    omenAppName: 'Carrot-prod',
    broodAPIURL: 'http://alb.us-west-2.prod.brood.live-video.a2z.com',
    liveProxyAPIURL: 'us-west-2.prod.liveproxyapi.live-video-ext.a2z.com',
    liveProxyAPIARN: 'arn:aws:execute-api:us-west-2:713208205855:*/*/*/*',
    originDCs: 'sjc02,cmh01,lhr05,pdx05',
  }
});
