import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';

import { CarrotSystemHealth, CSHProps } from './carrot-system-health/carrot-system-health'

export interface CarrotSystemHealthProps {
  cdkProps: cdk.StackProps;
  cshProps: CSHProps;
  vpcId: string
}

export class CarrotSystemHealthStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: CarrotSystemHealthProps) {
    super(scope, id, props.cdkProps);

    let vpc = ec2.Vpc.fromLookup(this, 'CarrotVpcRef', {
      vpcId: props.vpcId,
    })

    new CarrotSystemHealth(this, 'CarrotSystemHealth', vpc, props.cshProps)
  }
}
