import lambda = require('@aws-cdk/aws-lambda');
import ec2 = require('@aws-cdk/aws-ec2');
import iam = require('@aws-cdk/aws-iam');
import cdk = require('@aws-cdk/core');

export interface CSHProps {
  omenHost: string
  druidBroker: string
  omenAppName: string
  broodAPIURL: string
  liveProxyAPIURL: string
  liveProxyAPIARN: string
  invokeFunctionRoles: string[]
  originDCs: string
}

export class CarrotSystemHealth extends cdk.Construct {
  CSHLambda: lambda.Function

  constructor(scope: cdk.Construct, id: string, vpc: ec2.IVpc, props: CSHProps) {
    super(scope, id);

    this.CSHLambda = new lambda.Function(this, 'CarrotSystemHealth', {
      vpc: vpc,
      runtime: lambda.Runtime.GO_1_X,
      memorySize: 512,
      timeout: cdk.Duration.seconds(10),
      handler: 'bin/linux/carrot-system-health',
      code: lambda.Code.asset('../bin/carrot-system-health.zip'),
      environment: {
        "omenHost": props.omenHost,
        "druidBroker": props.druidBroker,
        "omenAppName": props.omenAppName,
        "broodAPIURL": props.broodAPIURL,
        "liveProxyAPIURL": props.liveProxyAPIURL,
        "originDCs": props.originDCs,
      }
    })

    for (let roleArn of props.invokeFunctionRoles) {
      this.CSHLambda.grantInvoke(new iam.ArnPrincipal(roleArn))
    }

    // Allow calls to liveproxyapi
    this.CSHLambda.addToRolePolicy(new iam.PolicyStatement({
      effect: iam.Effect.ALLOW,
      actions: ["execute-api:Invoke"],
      resources: [ props.liveProxyAPIARN ],
    }))
  }
}
