package main

import (
	"context"
	"encoding/json"
	"fmt"
	"strings"

	csh "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
	"code.justin.tv/event-engineering/carrot-system-health/pkg/svc"
	"github.com/sirupsen/logrus"
)

var origins = "sjc02,cmh01,lhr05,pdx05"

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	// Create the Service
	cshServer, err := svc.New(
		"http://omen.us-west-2.dev.gns.justin.tv/api/plyql/v1/query",
		"druid-broker-0-9-0-rc3.us-west-2.prod.gns.justin.tv:8082",
		"Carrot-localdev",
		"http://alb.us-west-2.prod.brood.live-video.a2z.com",
		"http://liveproxyapi-prod.video.twitch.a2z.com",
		strings.Split(origins, ","),
		logger,
	)

	if err != nil {
		panic(err)
	}

	doPoPHealth(cshServer)
}

func doPoPHealth(client svc.Client) {
	// Test your shit
	result, err := client.GetPoPHealth(context.Background(), &csh.GetPoPHealthRequest{})

	if err != nil {
		panic(err)
	}

	bytes, _ := json.MarshalIndent(result, "", "  ")
	fmt.Println(string(bytes))
}
