package main

import (
	"os"
	"strings"

	"code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	csh "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
	"code.justin.tv/event-engineering/carrot-system-health/pkg/svc"
	"github.com/sirupsen/logrus"
)

func main() {
	logger := logrus.New()
	logger.SetLevel(logrus.DebugLevel)

	omenHost := os.Getenv("omenHost")
	druidBroker := os.Getenv("druidBroker")
	omenAppName := os.Getenv("omenAppName")
	broodAPIURL := os.Getenv("broodAPIURL")
	liveProxyAPIURL := os.Getenv("liveProxyAPIURL")
	originDCs := os.Getenv("originDCs")

	// Create the Service
	cshServer, err := svc.New(omenHost, druidBroker, omenAppName, broodAPIURL, liveProxyAPIURL, strings.Split(originDCs, ","), logger)

	if err != nil {
		panic(err)
	}

	// Create a Twirp service based off the internal service
	server := csh.NewCarrotSystemHealthServer(cshServer, nil)

	err = lambda.ListenAndServe(":80", server)
	if err != nil {
		// TODO logging and metrics
		panic(err)
	}
}
