package brood

import (
	"context"
	"time"

	bapi "code.justin.tv/video/brood-api"
	bc "code.justin.tv/video/brood-client"
)

type Client interface {
	GetClusterList(ctx context.Context) (map[string]PoPStatus, error)
}

type client struct {
	brood *bc.Client
}

type PoPStatus struct {
	IsServingEdge      bool
	IsServingWeaver    bool
	NetworkEnvironment string
}

func New(broodAPIURL string) (Client, error) {
	broodClient, err := bc.New(&bc.Config{
		Url: broodAPIURL,
	})

	if err != nil {
		return nil, err
	}

	return &client{
		brood: broodClient,
	}, nil
}

func (c *client) GetClusterList(ctx context.Context) (map[string]PoPStatus, error) {
	resp, err := c.brood.GetClusters(ctx, &bapi.ClustersRequest{
		MaxAge:          time.Minute * 1,
		MaxStale:        time.Minute * 5,
		MaxStaleOnError: time.Hour * 25,
	})

	if err != nil {
		return nil, err
	}

	clusters := make(map[string]PoPStatus)

	for _, pop := range resp.Clusters {
		clusters[pop.Cluster] = PoPStatus{
			IsServingEdge:      pop.AssignmentEnabled,
			IsServingWeaver:    pop.WeaverClusterRatio > 0,
			NetworkEnvironment: pop.NetworkEnvironment.String(),
		}
	}

	return clusters, nil
}
