package svc

import (
	"regexp"
	"strings"

	rpc "code.justin.tv/event-engineering/carrot-system-health/pkg/rpc"
)

var popsThatWeShouldntReturn = []string{
	"",
	"cloudfront_vod",
	"unknown",
	"metro_vod",
	"sjc99",
}

func shouldReturn(pop string) bool {
	for _, noReturny := range popsThatWeShouldntReturn {
		if pop == noReturny {
			return false
		}
	}
	return true
}

// Probably should do some locking around this
func getOrSetPop(resp *rpc.GetPoPHealthResponse, pop string) *rpc.PoPHealth {
	if !shouldReturn(pop) {
		return nil
	}

	for _, poph := range resp.Pops {
		if strings.EqualFold(poph.Id, pop) {
			return poph
		}
	}

	poph := &rpc.PoPHealth{
		Id: pop,
	}

	resp.Pops = append(resp.Pops, poph)

	return poph
}

func getPop(resp *rpc.GetPoPHealthResponse, pop string) *rpc.PoPHealth {
	for _, poph := range resp.Pops {
		if strings.EqualFold(poph.Id, pop) {
			return poph
		}
	}

	return nil
}

var popRegex = regexp.MustCompile("[0-9]")

// For ingest pops where there is only 1 pop in a metro area there is no number in the ID
// e.g. the ingest pop in sao01 is just called sao in ingest terminology
// so we need to do something a bit different
func getPopFromIngestID(resp *rpc.GetPoPHealthResponse, ingestID string) *rpc.PoPHealth {
	// Check exact string (including number)
	for _, poph := range resp.Pops {
		if strings.EqualFold(poph.Id, ingestID) {
			return poph
		}
	}

	// Check just the non numeric part of the pop name
	for _, poph := range resp.Pops {
		popName := popRegex.ReplaceAllString(poph.Id, "")
		if strings.EqualFold(popName, ingestID) {
			return poph
		}
	}
	return nil
}
