#!/usr/bin/env node
import 'source-map-support/register';
import * as cdk from '@aws-cdk/core';
import { CarrotVpcStack, CarrotVpcProps } from '../lib/carrot-vpc-stack';
import {CarrotDnsStack} from "../lib/carrot-dns-stack";

const app = new cdk.App();
const stgVpc = new CarrotVpcStack(app, 'carrot-vpc-stg', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
    terminationProtection: true,
  },
  cidr: '10.207.220.0/22',
});

const prodVpc = new CarrotVpcStack(app, 'carrot-vpc-prod', {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  cidr: '10.207.212.0/22',
});

const stgDns = new CarrotDnsStack(app, 'carrot-dns-stg', stgVpc.Vpc, {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '134277936734',
    },
    terminationProtection: true,
  },
  zoneName: 'stg.support.contribute.live-video.net',
  delegations: []
})

const prodDns = new CarrotDnsStack(app, 'carrot-dns-prod', prodVpc.Vpc, {
  cdkProps: {
    env: {
      region: 'us-west-2',
      account: '782947612856',
    },
    terminationProtection: true,
  },
  zoneName: 'support.contribute.live-video.net',
  delegations: [{
    name: 'StagingDelegation',
    hostedZoneName: 'stg.support.contribute.live-video.net',
    nameServers: [ // I can't be bothered with cross stack delegation shit so I just deployed stg then copied this stuff
      'ns-23.awsdns-02.com.',
      'ns-1629.awsdns-11.co.uk.',
      'ns-1038.awsdns-01.org.',
      'ns-615.awsdns-12.net.',
    ]
  }],
})