var clientId = 'n2izkoxzqqx4x9tmi2jyfgfry1ids7';
var ws;

// Source: https://www.thepolyglotdeveloper.com/2015/03/create-a-random-nonce-string-using-javascript/
function nonce(length) {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    for (var i = 0; i < length; i++) {
        text += possible.charAt(Math.floor(Math.random() * possible.length));
    }
    return text;
}

function heartbeat() {
    message = {
        type: 'PING'
    };
    $('.ws-output').append('SENT: ' + JSON.stringify(message) + '\n');
    ws.send(JSON.stringify(message));
}

function listen(topic) {
    message = {
        type: 'LISTEN',
        nonce: nonce(15),
        data: {
            topics: [topic]
        }
    };
    $('.ws-output').append('SENT: ' + JSON.stringify(message) + '\n');
    ws.send(JSON.stringify(message));
}

function numerify(num){
  return num.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
}

function connect() {
    var heartbeatInterval = 1000 * 60; //ms between PING's
    var reconnectInterval = 1000 * 3; //ms to wait before reconnect
    var heartbeatHandle;

    ws = new WebSocket('wss://pubsub-edge.twitch.tv');

    ws.onopen = function(event) {
        $('.ws-output').append('INFO: Socket Opened\n');
        heartbeat();
        heartbeatHandle = setInterval(heartbeat, heartbeatInterval);
        for (var i = 0; i < window.__model.length; i++) {
          listen('video-playback-by-id.' + window.__model[i].user_id);
        }
    };

    ws.onerror = function(error) {
        $('.ws-output').append('ERR:  ' + JSON.stringify(error) + '\n');
    };

    ws.onmessage = function(event) {
        message = JSON.parse(event.data);

        if (message.type == 'MESSAGE') {
            var messageData = JSON.parse(message.data.message);
            if (messageData.type === 'viewcount') {
              updateViewcount(parseInt(message.data.topic.replace(/^video-playback-by-id.([0-9]+)$/, '$1')), messageData);
            }
        }
        if (message.type == 'RECONNECT') {
            console.log('reconnect');
            setTimeout(connect, reconnectInterval);
        }
    };

    ws.onclose = function() {
        $('.ws-output').append('INFO: Socket Closed\n');
        clearInterval(heartbeatHandle);
        $('.ws-output').append('INFO: Reconnecting...\n');
        setTimeout(connect, reconnectInterval);
    };

}

function localStorageKey(userId){
  return "ccu_store_" + userId;
}

function updateViewcount(userId, messageData) {
    var cachedMaxCCU = localStorage.getItem(localStorageKey(userId))
    if (cachedMaxCCU !== null && messageData.viewers > cachedMaxCCU) {
      localStorage.setItem(localStorageKey(userId), messageData.viewers);
    }

    for (var i = 0; i < window.__model.length; i++) {
      if (window.__model[i].user_id == userId) {
        window.__model[i].current_ccu = messageData.viewers;
        if (window.__model[i].max_ccu < messageData.viewers) {
          window.__model[i].max_ccu = messageData.viewers;
        }
        break;
      }
    }

    updateDisplay()
}

function updateDisplay() {
  var total = 0;
  var userIds = [];
  var items = [];

  for (var i = 0; i < window.__model.length; i++) {
    userIds.push(window.__model[i].user_id);
    total += window.__model[i].current_ccu;
    window.__model[i].element.html('<span class="label">' + window.__model[i].user_login + ': </span>' + numerify(window.__model[i].current_ccu))
  }

  $('#current').html('<span class="label">Current: </span>' + numerify(total))

  var allCacheKey = userIds.sort().join(',')

  var cachedMaxCCU = localStorage.getItem(localStorageKey(allCacheKey))
  if (cachedMaxCCU === null || cachedMaxCCU < total) {
    localStorage.setItem(localStorageKey(allCacheKey), total);
    cachedMaxCCU = total;
  }

  $('#peak').html('<span class="label">Peak: </span>' + numerify(cachedMaxCCU))
}

function updateDetail() {
  var active = $('#detail > li.active')
  var next = active.next();

  if (next.length == 0){
    next = $('#detail > li:first-child')
  }

  active.removeClass('active')
  next.addClass('active')
}

$(function() {
  var url = new URL(window.location.href)
  var logins = url.searchParams.getAll('login')

  if (logins.length > 0) {
    qs = '?';
    for (var i = 0; i < logins.length; i++) {
        qs += (i > 0 ? '&' : '') + 'login='+logins[i];
    }

    $.ajax({
      url: "https://api.twitch.tv/helix/users" + qs,
      method: "GET",
      headers: {
          "Client-ID": clientId
      }
    })
    .done(function(users) {
        window.__model = [];

        for (var i = 0; i < users.data.length; i++) {
          var cachedMaxCCU = localStorage.getItem(localStorageKey(users.data[i].id)) || 0;

          var loginElement = $('<li />');
          if (i == 0) {
            loginElement.addClass('active');
          }
          $("#detail").append(loginElement)

          window.__model.push({
            user_id: users.data[i].id,
            user_login: users.data[i].login,
            max_ccu: cachedMaxCCU,
            current_ccu: 0,
            element: loginElement
          })
        }
        connect();
        $('.socket').show()
        updateDisplay()
        setInterval(updateDetail, 10000)
    });
  }
});
