var updateTimer, element, userTimezoneOffset

function ready() {
  updateTimer = setInterval(updatetime, 100)
  element = document.getElementById('clock')
  secondsElement = document.getElementById('seconds')
  userTimezoneOffset = 0

  var url = new URL(window.location.href)
  // If the user has specified a timezone offset then use that offset from UTC, otherwise just use the user's local time
  var timezone_offset = url.searchParams.get('timezone_offset')
  if (timezone_offset) {
    userTimezoneOffset = parseInt(timezone_offset)
  } else {
    userTimezoneOffset = new Date().getTimezoneOffset() * -1
  }

  var ntp_server = url.searchParams.get('ntp_server')
  if (ntp_server) {
    NTP.ntpServer = ntp_server;
  }
}

function updatetime(){
  var time = new Date()

  // Grab the NTP synced time.Now()
  var timestamp = NTP.fixTime();

  // Offset the timestamp relative to the user's local time, I should document this better
  time.setTime(timestamp + ((time.getTimezoneOffset() + userTimezoneOffset) * 60000))

  var h = time.getHours().toString()
  if (h.length == 1) {
    h = "0" + h
  }

  var m = time.getMinutes().toString()
  if (m.length == 1) {
    m = "0" + m
  }

  var s = time.getSeconds().toString()
  if (s.length == 1) {
    s = "0" + s
  }

  var output = h + ":" + m;
  element.innerHTML = output
  secondsElement.innerHTML = s
  updateTicks(time.getSeconds())
}

function updateTicks(seconds) {
  for (var i = 0; i < 60; i++) {
    if (i <= seconds) {
      document.getElementById('s_'+i).setAttribute('style', 'opacity:1;')
    } else {
      document.getElementById('s_'+i).setAttribute('style', 'opacity:0.2;')
    }
  }
}

window.onload = ready
