/*
NTP.js https://jehiah.cz/a/ntp-for-javascript
copyright Jehiah Czebotar jehiah@gmail.com
licensed under http://unlicense.org/ please modify as needed
*/
var NTP = {
  cookieShelfLife : 7, //7 days
  requiredResponses : 2,
  serverTimes : new Array,
  serverUrl : "https://isn5lj65x4.execute-api.us-west-2.amazonaws.com/dev/time",
  ntpServer: '',
  resyncTime : 10, // minutes
  sync : function() {
    // if the time was set within the last x minutes; ignore this set request; time was synce recently enough
    var offset = NTP.getCookie("NTPClockOffset");
    if (offset){
      try {
    	  var t = offset.split("|")[1];
    	  var d = NTP.fixTime() - parseInt(t,10);
        if (d < (1000 * 60 * NTP.resyncTime)) {
          return false;
        } // x minutes; return==skip
      } catch (e) {

      }
    }

    NTP.serverTimes = new Array;
    NTP.getServerTime();
  },
  getNow : function() {
    var date = new Date();
    return date.getTime();
    return (date.getTime() + (date.getTimezoneOffset() * 60000));
  },
  parseServerResponse : function(data){
     var offset = parseInt(data.responseText.split(":")[0]);
     var origtime = parseInt(data.responseText.split(":")[1]);
     var delay = ((NTP.getNow() - origtime) / 2);
     offset = offset - delay;
     NTP.serverTimes.push(offset);

     // if we have enough responces set cookie
     if (NTP.serverTimes.length >= NTP.requiredResponses) {
    	 // build average
    	 var average = 0;
    	 var i = 0;
    	 for (i = 0; i < NTP.serverTimes.length; i++){
  	     average += NTP.serverTimes[i];
    	 }
    	 average = Math.round(average / i);
    	 NTP.setCookie("NTPClockOffset", average); // set the new offset
    	 NTP.setCookie("NTPClockOffset", average + '|' + NTP.fixTime()); // save the timestamp that we are setting it
     } else {
	     NTP.getServerTime();
     }
  },
  getServerTime : function(){
    var xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
        NTP.parseServerResponse(this)
      }
    };
    xhttp.open("GET", NTP.serverUrl + "?t=" + NTP.getNow() + (NTP.ntpServer ? "&s=" + encodeURIComponent(NTP.ntpServer) : ''), true);
    xhttp.send();
  },
  setCookie : function(aCookieName,aCookieValue){
     var date = new Date();
     date.setTime(date.getTime() + (NTP.cookieShelfLife * 24 * 60 * 60 * 1000));
     var expires = '; expires=' + date.toGMTString();
     document.cookie = NTP.getCookieName(aCookieName) + '=' + aCookieValue + expires + '; path=/';
  },
  getCookie : function(aCookieName){
     var crumbs = document.cookie.split('; ');
     for (var i = 0; i < crumbs.length; i++) {
    	 var crumb = crumbs[i].split('=');
    	 if (crumb[0] == NTP.getCookieName(aCookieName) && crumb[1] != null) {
         return crumb[1];
    	 }
     }
     return false;
  },
  getCookieName : function(cookieName) {
    return cookieName + (NTP.ntpServer ? '-' + NTP.ntpServer : '')
  },
  fixTime : function(timeStamp){
    if (!timeStamp) {
      timeStamp = NTP.getNow();
    }
    var offset = NTP.getCookie("NTPClockOffset") ;
    try {
  	  if (!offset) {
        offset = 0;
      } else {
        offset=offset.split("|")[0];
      }
  	  if (isNaN(parseInt(offset, 10))) {
        return timeStamp;
      }
  	  return timeStamp + parseInt(offset,10);
    } catch (e) {
      return timeStamp;
    }
  }
}

setTimeout(NTP.sync, 2500);
