package main

import (
	"log"
	"net/rpc"
	"os"

	"code.justin.tv/event-engineering/covfefe/pkg/client/destination"
	"code.justin.tv/event-engineering/covfefe/pkg/client/route"
	"code.justin.tv/event-engineering/covfefe/pkg/client/source"
	"github.com/urfave/cli"
)

func main() {
	client, err := rpc.DialHTTP("tcp", "127.0.0.1:1337")
	if err != nil {
		log.Fatal("dialing:", err)
	}

	app := cli.NewApp()
	app.EnableBashCompletion = true

	// Add the source commands
	source.Configure(client, &app.Commands)

	// Add the destination commands
	destination.Configure(client, &app.Commands)

	// Add the route commands
	route.Configure(client, &app.Commands)

	app.Run(os.Args)
}
