package main

import (
	"os"
	"os/signal"
	"sync"

	"code.justin.tv/event-engineering/covfefe/pkg/server/control"
)

func main() {
	go func() {
		sigchan := make(chan os.Signal, 10)
		signal.Notify(sigchan, os.Interrupt)
		<-sigchan

		control.HandleExit()

		os.Exit(0)
	}()

	var wait sync.WaitGroup
	wait.Add(1)

	go control.SetupController()

	wait.Wait()
}
