package api

/*=====================
		SOURCES
======================*/

// AddSourceRTMPLCallback defines callback for AddSourceRTMPL
type AddSourceRTMPLCallback func(ip string, port int, appName string) (id string, err error)

// RemoveSourceCallback defines callback for RemoveSource
type RemoveSourceCallback func(ID string) (id string, err error)

// ListSourcesCallback defines callback for ListSource
type ListSourcesCallback func() (sources []Source, err error)

/*=====================
	  DESTINATIONS
======================*/

// AddDestSRTMPCallback defines callback for AddDestSRTMP
type AddDestSRTMPCallback func(ip string, port int, appName string) (id string, err error)

// AddDestPRTMPCallback defines callback for AddDestPRTMP
type AddDestPRTMPCallback func(URL string) (id string, err error)

// AddDestFSCallback defines callback for AddDestFS
type AddDestFSCallback func(filePath string) (id string, err error)

// RemoveDestinationCallback defines callback for RemoveDestination
type RemoveDestinationCallback func(ID string) (id string, err error)

// ListDestinationsCallback defines callback for ListDestinations
type ListDestinationsCallback func() (destinations []Destination, err error)

/*=====================
		 ROUTES
======================*/

// AddRouteCallback defines callback for AddRoute
type AddRouteCallback func(sourceID string) (err error)

// LinkRouteCallback defines callback for LinkRoute
type LinkRouteCallback func(sourceID string, destinationID string) (err error)

// UnlinkRouteCallback defines callback for UnlinkRoute
type UnlinkRouteCallback func(sourceID string, destinationID string) (err error)

// ActivateRouteCallback defines callback for ActivateRoute
type ActivateRouteCallback func(sourceID string, destinationID string) (err error)

// DeactivateRouteCallback defines callback for DeactivateRoute
type DeactivateRouteCallback func(sourceID string, destinationID string) (err error)

// ListRoutesCallback defines callback for ListRoutes
type ListRoutesCallback func() (routes []Route, err error)

// RemoveRouteCallback defines callback for RemoveRoute
type RemoveRouteCallback func(sourceID string) (err error)

// Listener describes methods of listening to controls, e.g. CLI, REST API, Socket etc.
type Listener struct {
	OnAddSourceRTMPL    AddSourceRTMPLCallback
	OnRemoveSource      RemoveSourceCallback
	OnListSources       ListSourcesCallback
	OnAddDestSRTMP      AddDestSRTMPCallback
	OnAddDestPRTMP      AddDestPRTMPCallback
	OnAddDestFS         AddDestFSCallback
	OnRemoveDestination RemoveDestinationCallback
	OnListDestinations  ListDestinationsCallback
	OnAddRoute          AddRouteCallback
	OnLinkRoute         LinkRouteCallback
	OnUnlinkRoute       UnlinkRouteCallback
	OnActivateRoute     ActivateRouteCallback
	OnDeactivateRoute   DeactivateRouteCallback
	OnListRoutes        ListRoutesCallback
	OnRemoveRoute       RemoveRouteCallback
}
