package api

/*=====================
		SOURCES
======================*/

// AddSourceRTMPLArgs arguments for AddSourceRTMPL call
type AddSourceRTMPLArgs struct {
	IP      string
	Port    int
	AppName string
}

// AddSourceRTMPLResponse response for AddSourceRTMPL call
type AddSourceRTMPLResponse struct {
	ID      string
	Type    int
	IP      string
	Port    int
	AppName string
}

// RemoveSourceArgs arguments for RemoveSource call
type RemoveSourceArgs struct {
	ID string
}

// RemoveSourceResponse response for RemoveSource call
type RemoveSourceResponse struct {
	ID string
}

// ListSourcesArgs arguments for ListSources call
type ListSourcesArgs struct {
}

// Source type for ListSources call
type Source struct {
	ID   string            `json:"id"`
	Type int               `json:"type"`
	Data map[string]string `json:"data"`
}

// ListSourcesResponse response for ListSources call
type ListSourcesResponse struct {
	Sources []Source
}

/*=====================
	  DESTINATIONS
======================*/

// AddDestSRTMPArgs arguments for AddDestSRTMP call
type AddDestSRTMPArgs struct {
	IP      string
	Port    int
	AppName string
}

// AddDestSRTMPResponse response for AddDestSRTMP call
type AddDestSRTMPResponse struct {
	ID      string
	Type    int
	IP      string
	Port    int
	AppName string
}

// AddDestPRTMPArgs arguments for AddDestPRTMP call
type AddDestPRTMPArgs struct {
	URL string
}

// AddDestPRTMPResponse response for AddDestPRTMP call
type AddDestPRTMPResponse struct {
	ID   string
	Type int
	URL  string
}

// AddDestFSArgs arguments for AddDestFS call
type AddDestFSArgs struct {
	FilePath string
}

// AddDestFSResponse response for AddDestFS call
type AddDestFSResponse struct {
	ID       string
	Type     int
	FilePath string
}

// RemoveDestinationArgs arguments for RemoveDestination call
type RemoveDestinationArgs struct {
	ID string
}

// RemoveDestinationResponse response for RemoveDestination call
type RemoveDestinationResponse struct {
	ID string
}

// ListDestinationsArgs arguments for ListDestinations call
type ListDestinationsArgs struct {
}

// Destination type for ListDestinations call
type Destination struct {
	ID   string            `json:"id"`
	Type int               `json:"type"`
	Data map[string]string `json:"data"`
}

// ListDestinationsResponse response for ListDestinations call
type ListDestinationsResponse struct {
	Destinations []Destination
}

/*=====================
		 ROUTES
======================*/

// AddRouteArgs arguments for AddRoute call
type AddRouteArgs struct {
	SourceID string
}

// AddRouteResponse response for AddRoute call
type AddRouteResponse struct {
	SourceID string
}

// LinkRouteArgs arguments for LinkRoute call
type LinkRouteArgs struct {
	SourceID      string
	DestinationID string
}

// LinkRouteResponse response for LinkRoute call
type LinkRouteResponse struct {
	SourceID      string
	DestinationID string
}

// UnlinkRouteArgs arguments for UnlinkRoute call
type UnlinkRouteArgs struct {
	SourceID      string
	DestinationID string
}

// UnlinkRouteResponse response for UnlinkRoute call
type UnlinkRouteResponse struct {
	SourceID      string
	DestinationID string
}

// ActivateRouteArgs arguments for ActivateRoute call
type ActivateRouteArgs struct {
	SourceID      string
	DestinationID string
}

// ActivateRouteResponse response for ActivateRoute call
type ActivateRouteResponse struct {
	SourceID      string
	DestinationID string
}

// DeactivateRouteArgs arguments for DeactivateRoute call
type DeactivateRouteArgs struct {
	SourceID      string
	DestinationID string
}

// DeactivateRouteResponse response for DeactivateRoute call
type DeactivateRouteResponse struct {
	ID            string
	SourceID      string
	DestinationID string
}

// RemoveRouteArgs arguments for RemoveRoute call
type RemoveRouteArgs struct {
	SourceID string
}

// RemoveRouteResponse response for RemoveRoute call
type RemoveRouteResponse struct {
	SourceID string
}

// ListRoutesArgs arguments for ListRoutes call
type ListRoutesArgs struct {
}

// Route type for ListRoutes call
type Route struct {
	SourceID     string                     `json:"id"`
	Destinations map[string]RouteDestParams `json:"data"`
}

// RouteDestParams type for ListRoutes call
type RouteDestParams struct {
	Active bool `json:"active"`
}

// ListRoutesResponse response for ListRoutes call
type ListRoutesResponse struct {
	Routes []Route
}
