package control

import (
	"fmt"

	"code.justin.tv/event-engineering/covfefe/pkg/server/api"
)

/*=====================
	  DESTINATIONS
======================*/

func handleAddDestSRTMP(ip string, port int, appName string) (id string, err error) {
	id, err = currentState.AddDestSRTMP(ip, port, appName)
	if err != nil {
		fmt.Println("Error creating destination ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Added Serve RTMP Destination with ID: %v\n", id)
	}

	return id, err
}

func handleAddDestPRTMP(URL string) (id string, err error) {
	id, err = currentState.AddDestPRTMP(URL)
	if err != nil {
		fmt.Println("Error creating destination ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Added Push RTMP Destination with ID: %v\n", id)
	}

	return id, err
}

func handleAddDestFS(filePath string) (id string, err error) {
	id, err = currentState.AddDestFS(filePath)
	if err != nil {
		fmt.Println("Error creating destination ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Added File Sink Destination with ID: %v\n", id)
	}

	return id, err
}

func handleRemoveDestination(ID string) (string, error) {
	err := currentState.RemoveDestination(ID)
	if err != nil {
		fmt.Println("Error removing destination ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Removed destination with ID: %v\n", ID)
	}

	return ID, err
}

func handleListDestinations() ([]api.Destination, error) {
	response := make([]api.Destination, 0)
	for id, dest := range currentState.Destinations {
		response = append(response, api.Destination{
			ID:   id,
			Type: dest.Type,
			Data: dest.Data,
		})
	}

	return response, nil
}
