package control

import (
	"fmt"

	"code.justin.tv/event-engineering/covfefe/pkg/server/api"
)

/*=====================
		 ROUTES
======================*/

func handleAddRoute(sourceID string) (err error) {
	err = currentState.AddRoute(sourceID)
	if err != nil {
		fmt.Println("Error creating route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Added Route with Source ID: %v\n", sourceID)
	}

	return err
}

func handleLinkRoute(sourceID string, destinationID string) (err error) {
	err = currentState.LinkRoute(sourceID, destinationID)
	if err != nil {
		fmt.Println("Error linking route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Linked source %v to Destination %v\n", sourceID, destinationID)
	}

	return err
}

func handleUnlinkRoute(sourceID string, destinationID string) (err error) {
	err = currentState.UnlinkRoute(sourceID, destinationID)
	if err != nil {
		fmt.Println("Error unlinking route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Unlinked Destination %v from Source %v\n", destinationID, sourceID)
	}

	return err
}

func handleActivateRoute(sourceID string, destinationID string) (err error) {
	err = currentState.ActivateRoute(sourceID, destinationID)
	if err != nil {
		fmt.Println("Error activating route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Activated Destination %v with Source %v\n", destinationID, sourceID)
	}

	return err
}

func handleDeactivateRoute(sourceID string, destinationID string) (err error) {
	err = currentState.DeactivateRoute(sourceID, destinationID)
	if err != nil {
		fmt.Println("Error deactivating route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Deactivated Destination %v with Source %v\n", destinationID, sourceID)
	}

	return err
}

func handleRemoveRoute(sourceID string) error {
	err := currentState.RemoveRoute(sourceID)
	if err != nil {
		fmt.Println("Error removing route ", err)
		return err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Removed route with Source ID: %v\n", sourceID)
	}

	return err
}

func handleListRoutes() ([]api.Route, error) {
	response := make([]api.Route, 0)
	for _, route := range currentState.Routes {
		apiRoute := api.Route{
			SourceID: route.SourceID,
		}

		destinations := make(map[string]api.RouteDestParams, 0)
		apiRoute.Destinations = destinations

		for id, destination := range route.Destinations {
			destinations[id] = api.RouteDestParams{
				Active: destination.Active,
			}
		}

		response = append(response, apiRoute)
	}

	return response, nil
}
