package control

import (
	"fmt"

	"code.justin.tv/event-engineering/covfefe/pkg/server/api"
)

/*=====================
		SOURCES
======================*/

func handleAddSourceRTMPL(ip string, port int, appName string) (id string, err error) {
	id, err = currentState.AddSourceRTMPL(ip, port, appName)
	if err != nil {
		fmt.Println("Error creating source ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Added RTMP Listener source with ID: %v\n", id)
	}

	return id, err
}

func handleRemoveSource(ID string) (string, error) {
	err := currentState.RemoveSource(ID)
	if err != nil {
		fmt.Println("Error removing source ", err)
		return "", err
	}

	err = commitState()

	if err == nil {
		fmt.Printf("Removed source with ID: %v\n", ID)
	}

	return ID, err
}

func handleListSources() ([]api.Source, error) {
	response := make([]api.Source, 0)
	for id, source := range currentState.Sources {
		response = append(response, api.Source{
			ID:   id,
			Type: source.Type,
			Data: source.Data,
		})
	}

	return response, nil
}
