package db

import (
	"encoding/binary"
	"log"
	"os"

	"github.com/boltdb/bolt"
)

// Covfefe databsae object
type Covfefe struct {
	db *bolt.DB
}

// Init open database in provided location
func Init(location string) *Covfefe {
	var c Covfefe
	boltDb, err := bolt.Open(location, 0600, nil)
	if err != nil {
		log.Fatal(err)
		os.Exit(1)
	}

	c.db = boltDb

	return &c
}

// Close close db for provided database object
func (c *Covfefe) Close() {
	c.db.Close()
}

func itob(v int) []byte {
	b := make([]byte, 8)
	binary.BigEndian.PutUint64(b, uint64(v))
	return b
}
