package db

import (
	"log"

	"github.com/boltdb/bolt"
)

func (c *Covfefe) ReadState() (data []byte, err error) {
	err = c.db.Update(func(tx *bolt.Tx) error {
		b, err := tx.CreateBucketIfNotExists([]byte("db"))
		if err != nil {
			return err
		}

		data = b.Get([]byte("state"))

		return nil
	})

	if err != nil {
		log.Print(err)
		return nil, err
	}

	return data, nil
}

func (c *Covfefe) WriteState(data []byte) error {
	err := c.db.Update(func(tx *bolt.Tx) error {
		b, err := tx.CreateBucketIfNotExists([]byte("db"))
		if err != nil {
			return err
		}
		return b.Put([]byte("state"), data)
	})

	if err != nil {
		log.Print(err)
		return err
	}

	return nil
}
