window.players = {}
var clientId = 'vhypumepypqqx92p99w3brwn01ipyk';

function createPlayer(id, channel, isDefault) {
  var element = document.getElementById(id)
  var twitchPlayer = new Twitch.Player(id, {
    player: 'site',
    channel: channel
  });

  var player = {
    twitchPlayer: twitchPlayer,
    element: element,
    channel: channel
  }

  window.players[id] = player;

  var screen = document.createElement('div')
  screen.setAttribute('class', 'player_screen')
  player.screen = screen;
  element.appendChild(screen)

  var label = document.createElement('div')
  player.label = label;
  label.setAttribute('class', 'player_label')
  screen.appendChild(label)
  label.innerHTML = channel

  if (isDefault) {
    activate(player)
  } else {
    deactivate(player)
  }

  screen.addEventListener('click', function(){
    deactivateAllPlayers()
    activate(player)
  })
}

function activate(player){
  player.screen.style = 'display:none;';
  player.element.setAttribute('class', 'player active');
  if (!previewIsActive()){
    player.twitchPlayer.setQuality('chunked')
    player.twitchPlayer.setMuted(false);
    player.twitchPlayer.setVolume(1);
  }

  setPreviewSource(player.channel)
  window.__activePlayer = player
}

function deactivate(player){
  player.screen.style = 'display:block;';
  player.element.setAttribute('class', 'player');
  var currentQuality = player.twitchPlayer.getQuality()
  if (currentQuality != '360p30') {
    player.twitchPlayer.setQuality('360p30');
  }
  player.twitchPlayer.setMuted(true);
}

function deactivateAllPlayers() {
  for (p in window.players) {
    if (window.players.hasOwnProperty(p)) {
      deactivate(window.players[p])
    }
  }
}

window.openPreview = function() {
  window.__previewWindow = window.open('./fs.html?origin=' + encodeURIComponent(window.origin))
  window.__activePlayer.twitchPlayer.setMuted(true)

  // TODO handle this with some onready callback
  setTimeout(function(){
    setPreviewSource(window.__activePlayer.channel)
  }, 1000)
}

function previewIsActive(){
  return window.__previewWindow && !window.__previewWindow.closed
}

function setPreviewSource(channel) {
  if (!previewIsActive()){
    return;
  }

  window.__previewWindow.postMessage({
    namespace: 'twitch-event-panel',
    type: 'channel-switch',
    message: {
      channel: channel
    }
  }, window.origin)
}

function setUpStreamHealth(config) {
  var apiKey = localStorage.getItem('EVENT_PANEL_API_KEY')

  var hash = window.location.hash;
  if (hash.length > 1){
    hashParts = hash.substring(1, hash.length).split('&')
    for (var hi = 0; hi < hashParts.length; hi++) {
      hashItem = hashParts[hi].split('=')
      if (hashItem[0] == 'api_key' && hashItem.length == 2) {
        apiKey = hashItem[1]
      }
    }
  }

  if (apiKey) {
    localStorage.setItem('EVENT_PANEL_API_KEY', apiKey)
    window.location.hash = '';
    window.__eventPanelAPIKey = apiKey;
    setInterval(updateStreamHealth, 5000)
    updateStreamHealth()
  }
}

function getPlayerByChannel(channel){
  for (var p in window.players){
    if (window.players.hasOwnProperty(p) && window.players[p].channel.toLowerCase() === channel.toLowerCase()){
      return window.players[p]
    }
  }
}

function updateStreamHealth() {
  var qs = '?';
  for (var i = 0; i < playerConfig.length; i++) {
    qs += (i > 0 ? '&' : '') + 'channel=' + playerConfig[i].channel;
  }

  $.ajax({
    url: "https://59iun3bv4h.execute-api.us-west-2.amazonaws.com/prod/health" + qs,
    method: "GET",
    headers: {
        "X-Api-Key": window.__eventPanelAPIKey
    }
  }).done(function(health) {
    for (var i = 0; i < health.channels.length; i++){
      var chan = health.channels[i]
      var player = getPlayerByChannel(chan.name);
      if (!player) {
        continue;
      }
      var style = 'status-default';

      var maxDetail = 0;
      if (chan.detail) {
        for (var ci = 0; ci < chan.detail.length; ci++){
          if (chan.detail[ci] > maxDetail) {
            maxDetail = chan.detail[ci];
          }
        }
      }

      switch (maxDetail) {
        case 1000:
          style = 'status-ok';
          break;
        case 1001:
        case 1002:
        case 1003:
          style = 'status-warn';
          break;
        case 1004:
        case 1005:
        case 1006:
        case 1007:
          style = 'status-error';
          break;
      }

      if (chan.status == 0){
        style = 'status-offline';
      }

      $(player.label).removeClass('status-default');
      $(player.label).removeClass('status-ok');
      $(player.label).removeClass('status-warn');
      $(player.label).removeClass('status-error');
      $(player.label).addClass(style);
    }
  });
}

setUpStreamHealth(window.playerConfig)

for (var i = 0; i < playerConfig.length; i++) {
  createPlayer(window.playerConfig[i].id, window.playerConfig[i].channel, window.playerConfig[i].default)
}
