window.addEventListener("message", postMessageHandler, false);
var originURL = new URL(window.location).searchParams.get('origin')

function postMessageHandler(event) {
  if (event.origin !== originURL) {
    return
  }

  if (event.data.namespace === 'twitch-event-panel' &&  event.data.type === 'channel-switch') {
    setChannel(event.data.message.channel)
  }
}

function setChannel(channel) {
  if (!window.__player){
    window.__player = new Twitch.Player('preview', {
      player: 'site',
      channel: channel,
      muted: false,
      volume: 1.0
    });
  } else {
    window.__player.setChannel(channel);
    window.__player.setMuted(false);
    window.__player.setVolume(1.0);
  }
}

function onPreviewClose() {
  console.log('closed')
}
