#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import { FailsafeNLBStack } from '../lib/failsafe-nlb';
import { FailsafeVPCStack } from '../lib/failsafe-vpc';

const sjc02LBTier = [
  // These are pulled from provisioner - SJC
  "10.23.7.221", "10.23.77.224", "10.23.77.228", "10.23.77.225", "10.23.77.238", "10.23.77.223", "10.23.77.226", "10.23.79.211", "10.23.79.215", "10.23.79.242", "10.23.79.248", "10.23.79.214", "10.23.79.241", "10.23.10.245", "10.23.2.225", "10.23.2.182", "10.23.2.168", "10.23.2.164", "10.23.2.10", "10.23.4.11", "10.23.4.10", "10.23.4.9", "10.23.4.110", "10.23.4.228", "10.23.4.212", "10.23.4.167", "10.23.6.108", "10.23.8.8", "10.23.10.227", "10.23.12.226", "10.23.12.61", "10.23.12.99", "10.23.12.137", "10.23.12.138", "10.23.14.244", "10.23.16.205", "10.23.16.204", "10.23.16.207", "10.23.16.164", "10.23.16.201", "10.23.16.187", "10.23.16.190", "10.23.16.111", "10.23.16.217", "10.23.16.105", "10.23.16.177", "10.23.16.110", "10.23.16.104", "10.23.16.107", "10.23.16.108", "10.23.16.202", "10.23.16.106", "10.23.16.180", "10.23.16.181", "10.23.16.183", "10.23.16.84", "10.23.16.246", "10.23.16.165", "10.23.16.87", "10.23.14.145", "10.23.7.68", "10.23.7.71", "10.23.7.161", "10.23.7.160", "10.23.7.163", "10.23.7.162", "10.23.7.62", "10.23.7.173", "10.23.7.65", "10.23.7.64", "10.23.7.172", "10.23.70.182", "10.23.76.165", "10.23.76.172", "10.23.76.186", "10.23.76.174", "10.23.76.196", "10.23.76.185"
]

const cmh01LBTier = [
  // These are pulled from provisioner - CMH
  "10.27.38.103", "10.27.38.177", "10.27.38.96", "10.27.38.99", "10.27.38.176", "10.27.38.98", "10.27.38.179", "10.27.38.109", "10.27.38.178", "10.27.38.108", "10.27.36.111", "10.27.36.110", "10.27.36.215", "10.27.36.105", "10.27.36.104", "10.27.36.214", "10.27.36.209", "10.27.36.107", "10.27.34.212", "10.27.34.55", "10.27.34.54", "10.27.34.215", "10.27.34.49", "10.27.34.214", "10.27.34.209", "10.27.34.208", "10.27.32.221", "10.27.32.83", "10.27.32.82", "10.27.32.223", "10.27.32.217", "10.27.32.216", "10.27.32.222", "10.27.32.93", "10.27.32.219", "10.27.35.217", "10.27.35.216", "10.27.37.218", "10.27.35.79", "10.27.35.78", "10.27.35.223", "10.27.35.73", "10.27.35.222", "10.27.37.221", "10.27.37.211", "10.27.37.193", "10.27.37.230", "10.27.37.93", "10.27.37.235", "10.27.37.195", "10.27.39.111", "10.27.39.110", "10.27.39.210", "10.27.39.211", "10.27.39.221", "10.27.39.220", "10.27.39.105", "10.27.39.223", "10.27.39.104", "10.27.39.107", "10.27.39.106", "10.27.39.85", "10.27.32.92"
]

const app = new cdk.App();

const prodUsWest2 = new FailsafeVPCStack(app, 'FailsafeVPC-prod-us-west-2', {
  cidr: '10.207.116.0/22',
  allowedCIDRs: [
    // This list is kinda weird in that deplying will error if you change the order of things, so only add to the end of the list
    {
      name: 'TwitchOffice',
      cidr: '64.125.35.114/32'
    },
  ],
  cdk: {
    stackName: 'FailsafeVPC-prod-us-west-2',
    env: {
      account: '290947725420',
      region: 'us-west-2',
    },
    terminationProtection: true,
  },
})

const prodUsEast2 = new FailsafeVPCStack(app, 'FailsafeVPC-prod-us-east-2', {
  cidr: '10.184.72.0/22',
  allowedCIDRs: [
    // This list is kinda weird in that deplying will error if you change the order of things, so only add to the end of the list
    {
      name: 'TwitchOffice',
      cidr: '64.125.35.114/32'
    },
  ],
  cdk: {
    stackName: 'FailsafeVPC-prod-us-east-2',
    env: {
      account: '482905475663',
      region: 'us-east-2',
    },
    terminationProtection: true,
  },
})

new FailsafeNLBStack(app, 'FailsafeNLB-prod-us-west-2', {
  vpc: prodUsWest2.VPC,
  cdk: {
    stackName: 'FailsafeNLB-prod-us-west-2',
    env: {
      account: '290947725420',
      region: 'us-west-2'
    },
    terminationProtection: true,
  },
  targets: sjc02LBTier,
});

new FailsafeNLBStack(app, 'FailsafeNLB-prod-us-east-2', {
  vpc: prodUsEast2.VPC,
  cdk: {
    stackName: 'FailsafeNLB-prod-us-east-2',
    env: {
      account: '482905475663',
      region: 'us-east-2'
    },
    terminationProtection: true,
  },
  targets: cmh01LBTier,
});
