import cdk = require('@aws-cdk/core');
import elb = require('@aws-cdk/aws-elasticloadbalancingv2');
import ec2 = require('@aws-cdk/aws-ec2');

export interface Props {
  vpc: ec2.Vpc,
  cdk: cdk.StackProps,
  targets: string[],
}

export class FailsafeNLBStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: Props) {
    super(scope, id, props.cdk);

    const nlb = new elb.NetworkLoadBalancer(this, 'FailsafeNLB', {
      vpc: props.vpc,
      internetFacing: true,
      loadBalancerName: 'EmergencyRTMPRelayNLB',
    })

    const lbTierTargetGroup = new elb.NetworkTargetGroup(this, 'FailsafeNLBTarget', {
      vpc: props.vpc,
      port: 1935,
      targetType: elb.TargetType.IP,
    })

    nlb.addListener('FailsafeNLBListener', {
      port: 1935,
      defaultTargetGroups: [lbTierTargetGroup],
    })

    for (var target of props.targets) {
      lbTierTargetGroup.addTarget(new elb.IpTarget(target, 1935, "all"))
    }
  }
}
