# goldengate (phone) bridge
VIP 24/7/365 phone support for our most important broadcasters

## What does it do?
This project is an integration with [Twilio](https://www.twilio.com) that provides our most important broadcasters with a 24/7 phone line they can call for any broadcast related emergencies.

Its configuration is powered by PagerDuty so that it fits in with a standard on-call schedule and will route the incoming call to the team members who are on call at the time, as well as escalating swiftly should that person not pick up for whatever reason.

### Architecture
This project uses API Gateway and Lambda to provide an API that can be called by Twilio to integrate incoming calls to custom business logic. It also makes use of SQS->Lambda triggers to enhance basic functionality with things like escalations after a set time period.

Calls are recorded and logged into JIRA so that they can be reviewed to improve our service.

### Serverless
The AWS configuration is managed using the [serverless](https://serverless.com/) framework and the resulting API Gateway endpoint is manually connected to Twilio.

Install serverless (yes you need node sorry):
```
npm install -g serverless
```

Prior to running any commands make sure you have two [AWS credential profiles](http://docs.aws.amazon.com/cli/latest/userguide/cli-multiple-profiles.html) configured for `twitch-video-ops-aws` and `twitch-video-ops-stg`. The `prod` and `stg` stages (environments) are tied to these profiles.

### Configuration
Configuration is split between Lambda environment variables which are configured in the environment config [yaml](config.stg.yml) files and [SSM Parameter Store](https://aws.amazon.com/systems-manager/features/#Parameter_Store) for secure parameters such as access tokens and keys.

### Working locally
Given the nature of this project - sitting between inputs from third party services and orchestrating with other 3rd party services - working locally is... basically impossible. There's lots of tests though :) Testing end-to-end happens on staging.

#### Counterfeiter
In order to be able to test things in isolation, all interactions with outside services are mocked using counterfeiter. So if you want to change anything that interacts with outside services, make sure you have it installed:

```
go get github.com/maxbrunsfeld/counterfeiter
go install github.com/maxbrunsfeld/counterfeiter
```

and update the mocks to include any new methods using `make mocks` and write tests for your changes.

### Testing
```
make test
```

### Deploying
Staging is the default deployment target
```
make deploy
```
To deploy to prod
```
make ENV=prod deploy
```
