package envparameterresolver

import (
	"code.justin.tv/event-engineering/goldengate/pkg/goldengate"
	logging "code.justin.tv/event-engineering/goldengate/pkg/logging/backend"
	"fmt"
	"os"
)

type resolver struct {
	logger logging.Logger
}

// New creates a new ENV parameter resolver
func New(logger logging.Logger) goldengate.ParameterResolver {
	return &resolver{
		logger: logger,
	}
}

func (r *resolver) GetParameters() (goldengate.Parameters, error) {
	ret := goldengate.Parameters{}

	// Populate Keys
	params := goldengate.GetParameters(ret, "env")

	r.logger.Debug(fmt.Sprintf("Mapping %v environment parameters", len(params)))

	// For each key get the value from ENV
	for _, mapping := range params {
		if val, ok := os.LookupEnv(mapping.TagValue); ok {
			mapping.Value = val
		} else {
			return ret, fmt.Errorf("Could not retrieve ENV parameter %v", mapping.TagValue)
		}
	}

	// Map the values to the struct
	goldengate.MapParameters(params, &ret)

	return ret, nil
}
