package envparameterresolver

import (
	loggingfakes "code.justin.tv/event-engineering/goldengate/pkg/logging/backend/backendfakes"
	"github.com/stretchr/testify/assert"
	"os"
	"testing"
)

func TestGetEnvParameters(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	fakeLogger := new(loggingfakes.FakeLogger)
	r := New(fakeLogger)

	// Test error retrieving parameters
	params, err := r.GetParameters()
	a.NotNil(err)

	// Set up ENV variables
	err = os.Setenv("twilioBridgeNumber", "1234567890")
	a.Nil(err)
	err = os.Setenv("conferenceName", "TESTCONF")
	a.Nil(err)
	err = os.Setenv("recordingBucketName", "RECORDINGBUCKET")
	a.Nil(err)
	err = os.Setenv("holdMusicURL", "HOLD_URL")
	a.Nil(err)
	err = os.Setenv("jiraHostname", "JIRA_HOST")
	a.Nil(err)
	err = os.Setenv("jiraConsumerKey", "JIRA_CONSUMER_KEY")
	a.Nil(err)
	err = os.Setenv("escalationPolicyID", "EP_ID")
	a.Nil(err)
	err = os.Setenv("teamID", "TEAM_ID")
	a.Nil(err)
	err = os.Setenv("blockedNumbers", "+441234567890")
	a.Nil(err)
	err = os.Setenv("blockedPrefixes", "+1800,")
	a.Nil(err)
	err = os.Setenv("jiraEnabled", "1")
	a.Nil(err)
	err = os.Setenv("pdEnabled", "0")
	a.Nil(err)
	err = os.Setenv("sqsQueueURL", "SQS_URL")
	a.Nil(err)
	err = os.Setenv("dynamoDbTableName", "DDB_TABLE")
	a.Nil(err)
	err = os.Setenv("batphoneNumbers", "BATPHONE_NUMBERS")
	a.Nil(err)

	// Test successful retrieval of ENV parameters
	params, err = r.GetParameters()

	a.Nil(err)
	a.EqualValues("1234567890", params.TwilioBridgeNumber, "wrong TwilioBridgeNumber returned")
	a.EqualValues("TESTCONF", params.ConferenceName, "wrong ConferenceName returned")
	a.EqualValues("RECORDINGBUCKET", params.RecordingBucketName, "wrong RecordingBucketName returned")
	a.EqualValues("HOLD_URL", params.HoldMusicURL, "wrong HoldMusicURL returned")
	a.EqualValues("JIRA_HOST", params.JiraHostname, "wrong JiraHostname returned")
	a.EqualValues("JIRA_CONSUMER_KEY", params.JiraConsumerKey, "wrong JiraConsumerKey returned")
	a.EqualValues("EP_ID", params.EscalationPolicyID, "wrong EscalationPolicyID returned")
	a.EqualValues("TEAM_ID", params.TeamID, "wrong TeamID returned")
	a.EqualValues("+441234567890", params.BlockedNumbers, "wrong BlockedNumbers returned")
	a.EqualValues("+1800,", params.BlockedPrefixes, "wrong BlockedPrefixes returned")
	a.EqualValues("SQS_URL", params.SQSQueueURL, "wrong SQSQueueURL returned")
	a.EqualValues("DDB_TABLE", params.DynamoDBTableName, "wrong DynamoDBTableName returned")
	a.EqualValues(true, params.JiraEnabled, "wrong JiraEnabled returned")
	a.EqualValues(false, params.PDEnabled, "wrong PDEnabled returned")
	a.EqualValues("BATPHONE_NUMBERS", params.BatphoneNumbers, "wrong BatphoneNumbers returned")
}
