package goldengate

import (
	awsBackend "code.justin.tv/event-engineering/goldengate/pkg/aws/backend"
	jiraBackend "code.justin.tv/event-engineering/goldengate/pkg/jira/backend"
	pdBackend "code.justin.tv/event-engineering/goldengate/pkg/pagerduty/backend"
	twilioBackend "code.justin.tv/event-engineering/goldengate/pkg/twilio/backend"
)

// BackendResolver is an interface defining methods for resolving backend clients for use in goldengate
type BackendResolver interface {
	GetPagerdutyBackend() pdBackend.Client
	GetJiraBackend() (jiraBackend.Client, error)
	GetTwilioBackend() twilioBackend.Client
	GetAWSBackend() (awsBackend.Client, error)
}
