package goldengate

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

type testMapping struct {
	StringTest string `test:"string_test"`
	BoolTest   bool   `test:"bool_test"`
	IntTest    int    `test:"int_test"`
}

func TestMapParameters(t *testing.T) {
	a := assert.New(t)
	params := map[string]*ParamMapping{
		"StringTest": &ParamMapping{
			Value: "1234567890",
		},
		"BoolTest": &ParamMapping{
			Value: "1",
		},
		"IntTest": &ParamMapping{
			Value: "1337",
		},
	}

	target := testMapping{}

	MapParameters(params, &target)

	a.EqualValues("1234567890", target.StringTest, "wrong StringTest returned")
	a.EqualValues(true, target.BoolTest, "wrong BoolTest returned")
	a.EqualValues(1337, target.IntTest, "wrong IntTest returned")

	// Test mapping an invalid Type
	badTarget := make([]string, 0)

	a.NotPanics(func() {
		MapParameters(params, &badTarget)
	})
}

func TestGetParameters(t *testing.T) {
	a := assert.New(t)

	target := testMapping{}

	mappings := GetParameters(&target, "test")

	a.NotNil(mappings)
	a.EqualValues(3, len(mappings), "wrong length returned for mappings")
	a.EqualValues("string_test", mappings["StringTest"].TagValue, "wrong tag value returned for StringTest mapping")
	a.EqualValues("bool_test", mappings["BoolTest"].TagValue, "wrong tag value returned for BoolTest mapping")
	a.EqualValues("int_test", mappings["IntTest"].TagValue, "wrong tag value returned for IntTest mapping")

	// Test mapping an invalid Type
	badTarget := make([]string, 0)

	a.NotPanics(func() {
		mappings = GetParameters(&badTarget, "test")
		a.Nil(mappings)
	})
}
