package handlers

import (
	"context"
	"github.com/aws/aws-lambda-go/events"
)

func (h *handlers) cloudwatchHandler(ctx context.Context, request events.CloudWatchEvent) error {
	h.logger.Debug("Cloudwatch handler called")
	// This is basically a no-op, we just need to keep the execution context fresh
	// I could do something like check the age of the stored parameters and re-fetch them after a certain time
	// but I think it's best to keep this handler as error free as possible, so the easiest way to do that is to have it do nothing at all

	// This will keep the list of team users fresh
	_ = h.pd.GetTeamUsers(h.TeamID, nil, h.TeamUsersCacheTime)

	return nil
}
