package handlers

import (
	pdBackend "code.justin.tv/event-engineering/goldengate/pkg/pagerduty/backend"
	"context"
	"github.com/aws/aws-lambda-go/events"
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestCloudwatchTrigger(t *testing.T) {
	t.Parallel()
	a := assert.New(t)
	ctx := context.TODO()

	backend, err := createMockBackend()
	a.Nil(err)

	backend.pd.ListTeamUsersStub = func(teamID string) (*pdBackend.ListUsersResponse, error) {
		// These IDs are declared in handlers_test.go in the createMockBackend function
		a.EqualValues("DEF456", teamID)
		return nil, nil
	}

	request := Request{
		CloudWatchEvent: events.CloudWatchEvent{
			DetailType: "Scheduled Event",
		},
	}

	_, err = backend.handlersPub.Handle(ctx, request)
	a.Nil(err)
	a.EqualValues(1, backend.pd.ListTeamUsersCallCount())
}
