package handlers

import (
	pdBackend "code.justin.tv/event-engineering/goldengate/pkg/pagerduty/backend"
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestHelpers(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	rootURL := generateRootURL("www.google.com", "beta")
	a.EqualValues("https://www.google.com/beta", rootURL)

	slice := []string{"test1"}

	present := isInSlice("test1", slice)
	a.EqualValues(true, present)

	present = isInSlice("test2", slice)
	a.EqualValues(false, present)

	resp := joinConferenceResponse("TestConference")

	a.NotNil(resp)
	a.EqualValues("text/xml", resp.Headers["Content-Type"])
	a.EqualValues(`<?xml version="1.0" encoding="UTF-8"?><Response><Say>Calls will be recorded</Say><Dial><Conference>TestConference</Conference></Dial></Response>`, resp.Body)

	user := &pdBackend.User{
		ID: "USER1",
		ContactMethods: []*pdBackend.ContactMethod{
			&pdBackend.ContactMethod{
				ID:          "CM2",
				Type:        "phone_contact_method",
				CountryCode: 44,
				Address:     "1234567890",
			},
		},
	}

	number := getUserNumber(user)

	a.EqualValues("+441234567890", number)

	user = &pdBackend.User{
		ID: "USER1",
		ContactMethods: []*pdBackend.ContactMethod{
			&pdBackend.ContactMethod{
				ID:      "CM1",
				Type:    "email_contact_method",
				Address: "example@example.com",
			},
		},
	}

	number = getUserNumber(user)

	a.EqualValues("", number)
}
