package backend

import (
	"github.com/Sirupsen/logrus"
)

// Logger wraps logging methods in an interface for mocks
// If this interface changes, counterfeiter must be re-run using `make mocks`
type Logger interface {
	Info(args ...interface{})
	Debug(args ...interface{})
	Warn(args ...interface{})
	Error(args ...interface{})
	Infof(format string, args ...interface{})
	Debugf(format string, args ...interface{})
	Warnf(format string, args ...interface{})
	Errorf(format string, args ...interface{})
}

type logger struct {
	logger *logrus.Logger
}

// New creates a logger object with a logrus Logger backend
func New(log *logrus.Logger) Logger {
	return &logger{
		logger: log,
	}
}

// Info calls the underlying Info logging method
func (l *logger) Info(args ...interface{}) {
	l.logger.Info(args...)
}

// Debug calls the underlying Debug logging method
func (l *logger) Debug(args ...interface{}) {
	l.logger.Debug(args...)
}

// Warn calls the underlying Warn logging method
func (l *logger) Warn(args ...interface{}) {
	l.logger.Warn(args...)
}

// Error calls the underlying Error logging method
func (l *logger) Error(args ...interface{}) {
	l.logger.Error(args...)
}

// Infof calls the underlying Infof logging method
func (l *logger) Infof(format string, args ...interface{}) {
	l.logger.Infof(format, args...)
}

// Debugf calls the underlying Debugf logging method
func (l *logger) Debugf(format string, args ...interface{}) {
	l.logger.Debugf(format, args...)
}

// Warnf calls the underlying Warnf logging method
func (l *logger) Warnf(format string, args ...interface{}) {
	l.logger.Warnf(format, args...)
}

// Errorf calls the underlying Errorf logging method
func (l *logger) Errorf(format string, args ...interface{}) {
	l.logger.Errorf(format, args...)
}
