package logging

import (
	"code.justin.tv/event-engineering/goldengate/pkg/logging/backend"
)

// New generates a new Jira Client with the supplied backend client
func New(logger backend.Logger) *Client {
	return &Client{
		logger: logger,
	}
}

// Client is a Logger containing methods for use in the goldengate system
type Client struct {
	logger backend.Logger
}

// Info calls the underlying Info logging method
func (l *Client) Info(args ...interface{}) {
	l.logger.Info(args...)
}

// Debug calls the underlying Debug logging method
func (l *Client) Debug(args ...interface{}) {
	l.logger.Debug(args...)
}

// Warn calls the underlying Warn logging method
func (l *Client) Warn(args ...interface{}) {
	l.logger.Warn(args...)
}

// Error calls the underlying Error logging method
func (l *Client) Error(args ...interface{}) {
	l.logger.Error(args...)
}

// Infof calls the underlying Infof logging method
func (l *Client) Infof(format string, args ...interface{}) {
	l.logger.Infof(format, args...)
}

// Debugf calls the underlying Debugf logging method
func (l *Client) Debugf(format string, args ...interface{}) {
	l.logger.Debugf(format, args...)
}

// Warnf calls the underlying Warnf logging method
func (l *Client) Warnf(format string, args ...interface{}) {
	l.logger.Warnf(format, args...)
}

// Errorf calls the underlying Errorf logging method
func (l *Client) Errorf(format string, args ...interface{}) {
	l.logger.Errorf(format, args...)
}
