package logging

import (
	loggingfakes "code.justin.tv/event-engineering/goldengate/pkg/logging/backend/backendfakes"
	"github.com/stretchr/testify/assert"
	"testing"
)

// This is probably one of the most pointless test suites in existence, but at least I can brag about 100% test coverage right? right?????

func TestLoggingPassthrough(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	fakeLogger := new(loggingfakes.FakeLogger)

	logger := New(fakeLogger)
	a.NotNil(logger)

	logger.Debug()
	logger.Debugf("")
	logger.Error()
	logger.Errorf("")
	logger.Info()
	logger.Infof("")
	logger.Warn()
	logger.Warnf("")

	a.EqualValues(1, fakeLogger.DebugCallCount())
	a.EqualValues(1, fakeLogger.DebugfCallCount())
	a.EqualValues(1, fakeLogger.ErrorCallCount())
	a.EqualValues(1, fakeLogger.ErrorfCallCount())
	a.EqualValues(1, fakeLogger.InfoCallCount())
	a.EqualValues(1, fakeLogger.InfofCallCount())
	a.EqualValues(1, fakeLogger.WarnCallCount())
	a.EqualValues(1, fakeLogger.WarnfCallCount())
}
