package backend

// Because there are zero good pagerduty clients for go, I'm just going to make a basic one that just does what I need

type OnCall struct {
	EscalationLevel int         `json:"escalation_level"`
	User            *OnCallUser `json:"user"`
}

type OnCallUser struct {
	ID             string                    `json:"id"`
	ContactMethods []*ContactMethodReference `json:"contact_methods"`
}

type User struct {
	ID             string           `json:"id"`
	ContactMethods []*ContactMethod `json:"contact_methods"`
}

type ContactMethodReference struct {
	Type string `json:"type"`
	ID   string `json:"id"`
}

type ContactMethod struct {
	Type        string `json:"type"`
	ID          string `json:"id"`
	Address     string `json:"address"`
	CountryCode int    `json:"country_code"`
}

type ListOnCallsResponse struct {
	OnCalls []*OnCall `json:"oncalls"`
}

type ListUsersResponse struct {
	Users []*User `json:"users"`
}

type GetContactMethodResponse struct {
	ContactMethod *ContactMethod `json:"contact_method"`
}

type errorObject struct {
	Code    int         `json:"code,omitempty"`
	Message string      `json:"message,omitempty"`
	Errors  interface{} `json:"errors,omitempty"`
}
