package pagerduty

import (
	pdBackend "code.justin.tv/event-engineering/goldengate/pkg/pagerduty/backend"
	"time"
)

type teamUsersCache struct {
	lastUpdated time.Time
	users       []*pdBackend.User
}

// GetTeamUsers returns a list of users with the supplied team ID, optionally filtering by the supplied user IDs
func (c *Client) GetTeamUsers(teamID string, userIDs []string, cacheTime time.Duration) []*pdBackend.User {
	if c.teamUsers == nil {
		c.teamUsers = &teamUsersCache{
			users: make([]*pdBackend.User, 0),
		}
	}

	if time.Now().Sub(c.teamUsers.lastUpdated) >= cacheTime {
		users, err := c.pd.ListTeamUsers(teamID)

		if err != nil {
			c.logger.Error("Error updating team users, using cached value")
		} else {
			if users == nil || users.Users == nil {
				c.logger.Warn("Empty Team List!")
			} else {
				c.teamUsers.users = users.Users
				c.teamUsers.lastUpdated = time.Now()
			}
		}
	}

	if userIDs != nil && len(userIDs) > 0 {
		ret := make([]*pdBackend.User, 0)
		for _, user := range c.teamUsers.users {
			for _, userID := range userIDs {
				if user.ID == userID {
					ret = append(ret, user)
				}
			}
		}

		return ret
	}

	return c.teamUsers.users
}
