package ssmparameterresolver

import (
	awsBackend "code.justin.tv/event-engineering/goldengate/pkg/aws/backend"
	"code.justin.tv/event-engineering/goldengate/pkg/goldengate"
	logging "code.justin.tv/event-engineering/goldengate/pkg/logging/backend"
	"fmt"
	"github.com/aws/aws-sdk-go/service/ssm"
)

type resolver struct {
	aws    awsBackend.Client
	logger logging.Logger
}

var withDecrpytion = true

// New creates a new SSM secure parameter resolver
func New(logger logging.Logger, aws awsBackend.Client) goldengate.SecureParameterResolver {
	return &resolver{
		logger: logger,
		aws:    aws,
	}
}

func (r *resolver) GetParameters() (goldengate.SecureParameters, error) {
	ret := goldengate.SecureParameters{}

	// Populate Keys
	params := goldengate.GetParameters(ret, "ssm")

	r.logger.Debug(fmt.Sprintf("Mapping %v SSM parameters", len(params)))

	// Grab the values from SSM
	paramNames := make([]*string, 0)
	for _, pn := range params {
		paramNames = append(paramNames, &pn.TagValue)
	}

	ssmResponse, err := r.aws.SSMGetParameters(&ssm.GetParametersInput{
		Names:          paramNames,
		WithDecryption: &withDecrpytion,
	})

	if err != nil {
		return ret, err
	}

	for _, param := range ssmResponse.Parameters {
		for _, pn := range params {
			if pn.TagValue == *param.Name {
				pn.Value = *param.Value
			}
		}
	}

	// Map the values to the struct
	goldengate.MapParameters(params, &ret)

	return ret, nil
}
