// Code generated by counterfeiter. DO NOT EDIT.
package backendfakes

import (
	"context"
	"io"
	"net/url"
	"sync"
	"time"

	"code.justin.tv/event-engineering/goldengate/pkg/twilio/backend"
	goTwilio "github.com/kevinburke/twilio-go"
)

type FakeClient struct {
	CallStub        func(from string, to string, u *url.URL) (*goTwilio.Call, error)
	callMutex       sync.RWMutex
	callArgsForCall []struct {
		from string
		to   string
		u    *url.URL
	}
	callReturns struct {
		result1 *goTwilio.Call
		result2 error
	}
	callReturnsOnCall map[int]struct {
		result1 *goTwilio.Call
		result2 error
	}
	HangupStub        func(sid string) (*goTwilio.Call, error)
	hangupMutex       sync.RWMutex
	hangupArgsForCall []struct {
		sid string
	}
	hangupReturns struct {
		result1 *goTwilio.Call
		result2 error
	}
	hangupReturnsOnCall map[int]struct {
		result1 *goTwilio.Call
		result2 error
	}
	GetExpectedSignatureStub        func(host string, authToken string, URL string, postForm url.Values) (expectedTwilioSignature string)
	getExpectedSignatureMutex       sync.RWMutex
	getExpectedSignatureArgsForCall []struct {
		host      string
		authToken string
		URL       string
		postForm  url.Values
	}
	getExpectedSignatureReturns struct {
		result1 string
	}
	getExpectedSignatureReturnsOnCall map[int]struct {
		result1 string
	}
	GetConferenceStub        func(ctx context.Context, sid string) (*goTwilio.Conference, error)
	getConferenceMutex       sync.RWMutex
	getConferenceArgsForCall []struct {
		ctx context.Context
		sid string
	}
	getConferenceReturns struct {
		result1 *goTwilio.Conference
		result2 error
	}
	getConferenceReturnsOnCall map[int]struct {
		result1 *goTwilio.Conference
		result2 error
	}
	GetConferencesStub        func(start time.Time, end time.Time, data url.Values) goTwilio.ConferencePageIterator
	getConferencesMutex       sync.RWMutex
	getConferencesArgsForCall []struct {
		start time.Time
		end   time.Time
		data  url.Values
	}
	getConferencesReturns struct {
		result1 goTwilio.ConferencePageIterator
	}
	getConferencesReturnsOnCall map[int]struct {
		result1 goTwilio.ConferencePageIterator
	}
	GetCallStub        func(ctx context.Context, sid string) (*goTwilio.Call, error)
	getCallMutex       sync.RWMutex
	getCallArgsForCall []struct {
		ctx context.Context
		sid string
	}
	getCallReturns struct {
		result1 *goTwilio.Call
		result2 error
	}
	getCallReturnsOnCall map[int]struct {
		result1 *goTwilio.Call
		result2 error
	}
	RetrieveRecordingStub        func(recordingURL string) (io.ReadCloser, error)
	retrieveRecordingMutex       sync.RWMutex
	retrieveRecordingArgsForCall []struct {
		recordingURL string
	}
	retrieveRecordingReturns struct {
		result1 io.ReadCloser
		result2 error
	}
	retrieveRecordingReturnsOnCall map[int]struct {
		result1 io.ReadCloser
		result2 error
	}
	GetConferenceParticipantsStub        func(ctx context.Context, conferenceSid string) (*backend.ConferenceParticipantsResponse, error)
	getConferenceParticipantsMutex       sync.RWMutex
	getConferenceParticipantsArgsForCall []struct {
		ctx           context.Context
		conferenceSid string
	}
	getConferenceParticipantsReturns struct {
		result1 *backend.ConferenceParticipantsResponse
		result2 error
	}
	getConferenceParticipantsReturnsOnCall map[int]struct {
		result1 *backend.ConferenceParticipantsResponse
		result2 error
	}
	GetConferenceRecordingsStub        func(ctx context.Context, conferenceSid string) (*backend.ConferenceRecordingsResponse, error)
	getConferenceRecordingsMutex       sync.RWMutex
	getConferenceRecordingsArgsForCall []struct {
		ctx           context.Context
		conferenceSid string
	}
	getConferenceRecordingsReturns struct {
		result1 *backend.ConferenceRecordingsResponse
		result2 error
	}
	getConferenceRecordingsReturnsOnCall map[int]struct {
		result1 *backend.ConferenceRecordingsResponse
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeClient) Call(from string, to string, u *url.URL) (*goTwilio.Call, error) {
	fake.callMutex.Lock()
	ret, specificReturn := fake.callReturnsOnCall[len(fake.callArgsForCall)]
	fake.callArgsForCall = append(fake.callArgsForCall, struct {
		from string
		to   string
		u    *url.URL
	}{from, to, u})
	fake.recordInvocation("Call", []interface{}{from, to, u})
	fake.callMutex.Unlock()
	if fake.CallStub != nil {
		return fake.CallStub(from, to, u)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.callReturns.result1, fake.callReturns.result2
}

func (fake *FakeClient) CallCallCount() int {
	fake.callMutex.RLock()
	defer fake.callMutex.RUnlock()
	return len(fake.callArgsForCall)
}

func (fake *FakeClient) CallArgsForCall(i int) (string, string, *url.URL) {
	fake.callMutex.RLock()
	defer fake.callMutex.RUnlock()
	return fake.callArgsForCall[i].from, fake.callArgsForCall[i].to, fake.callArgsForCall[i].u
}

func (fake *FakeClient) CallReturns(result1 *goTwilio.Call, result2 error) {
	fake.CallStub = nil
	fake.callReturns = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) CallReturnsOnCall(i int, result1 *goTwilio.Call, result2 error) {
	fake.CallStub = nil
	if fake.callReturnsOnCall == nil {
		fake.callReturnsOnCall = make(map[int]struct {
			result1 *goTwilio.Call
			result2 error
		})
	}
	fake.callReturnsOnCall[i] = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) Hangup(sid string) (*goTwilio.Call, error) {
	fake.hangupMutex.Lock()
	ret, specificReturn := fake.hangupReturnsOnCall[len(fake.hangupArgsForCall)]
	fake.hangupArgsForCall = append(fake.hangupArgsForCall, struct {
		sid string
	}{sid})
	fake.recordInvocation("Hangup", []interface{}{sid})
	fake.hangupMutex.Unlock()
	if fake.HangupStub != nil {
		return fake.HangupStub(sid)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.hangupReturns.result1, fake.hangupReturns.result2
}

func (fake *FakeClient) HangupCallCount() int {
	fake.hangupMutex.RLock()
	defer fake.hangupMutex.RUnlock()
	return len(fake.hangupArgsForCall)
}

func (fake *FakeClient) HangupArgsForCall(i int) string {
	fake.hangupMutex.RLock()
	defer fake.hangupMutex.RUnlock()
	return fake.hangupArgsForCall[i].sid
}

func (fake *FakeClient) HangupReturns(result1 *goTwilio.Call, result2 error) {
	fake.HangupStub = nil
	fake.hangupReturns = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) HangupReturnsOnCall(i int, result1 *goTwilio.Call, result2 error) {
	fake.HangupStub = nil
	if fake.hangupReturnsOnCall == nil {
		fake.hangupReturnsOnCall = make(map[int]struct {
			result1 *goTwilio.Call
			result2 error
		})
	}
	fake.hangupReturnsOnCall[i] = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetExpectedSignature(host string, authToken string, URL string, postForm url.Values) (expectedTwilioSignature string) {
	fake.getExpectedSignatureMutex.Lock()
	ret, specificReturn := fake.getExpectedSignatureReturnsOnCall[len(fake.getExpectedSignatureArgsForCall)]
	fake.getExpectedSignatureArgsForCall = append(fake.getExpectedSignatureArgsForCall, struct {
		host      string
		authToken string
		URL       string
		postForm  url.Values
	}{host, authToken, URL, postForm})
	fake.recordInvocation("GetExpectedSignature", []interface{}{host, authToken, URL, postForm})
	fake.getExpectedSignatureMutex.Unlock()
	if fake.GetExpectedSignatureStub != nil {
		return fake.GetExpectedSignatureStub(host, authToken, URL, postForm)
	}
	if specificReturn {
		return ret.result1
	}
	return fake.getExpectedSignatureReturns.result1
}

func (fake *FakeClient) GetExpectedSignatureCallCount() int {
	fake.getExpectedSignatureMutex.RLock()
	defer fake.getExpectedSignatureMutex.RUnlock()
	return len(fake.getExpectedSignatureArgsForCall)
}

func (fake *FakeClient) GetExpectedSignatureArgsForCall(i int) (string, string, string, url.Values) {
	fake.getExpectedSignatureMutex.RLock()
	defer fake.getExpectedSignatureMutex.RUnlock()
	return fake.getExpectedSignatureArgsForCall[i].host, fake.getExpectedSignatureArgsForCall[i].authToken, fake.getExpectedSignatureArgsForCall[i].URL, fake.getExpectedSignatureArgsForCall[i].postForm
}

func (fake *FakeClient) GetExpectedSignatureReturns(result1 string) {
	fake.GetExpectedSignatureStub = nil
	fake.getExpectedSignatureReturns = struct {
		result1 string
	}{result1}
}

func (fake *FakeClient) GetExpectedSignatureReturnsOnCall(i int, result1 string) {
	fake.GetExpectedSignatureStub = nil
	if fake.getExpectedSignatureReturnsOnCall == nil {
		fake.getExpectedSignatureReturnsOnCall = make(map[int]struct {
			result1 string
		})
	}
	fake.getExpectedSignatureReturnsOnCall[i] = struct {
		result1 string
	}{result1}
}

func (fake *FakeClient) GetConference(ctx context.Context, sid string) (*goTwilio.Conference, error) {
	fake.getConferenceMutex.Lock()
	ret, specificReturn := fake.getConferenceReturnsOnCall[len(fake.getConferenceArgsForCall)]
	fake.getConferenceArgsForCall = append(fake.getConferenceArgsForCall, struct {
		ctx context.Context
		sid string
	}{ctx, sid})
	fake.recordInvocation("GetConference", []interface{}{ctx, sid})
	fake.getConferenceMutex.Unlock()
	if fake.GetConferenceStub != nil {
		return fake.GetConferenceStub(ctx, sid)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.getConferenceReturns.result1, fake.getConferenceReturns.result2
}

func (fake *FakeClient) GetConferenceCallCount() int {
	fake.getConferenceMutex.RLock()
	defer fake.getConferenceMutex.RUnlock()
	return len(fake.getConferenceArgsForCall)
}

func (fake *FakeClient) GetConferenceArgsForCall(i int) (context.Context, string) {
	fake.getConferenceMutex.RLock()
	defer fake.getConferenceMutex.RUnlock()
	return fake.getConferenceArgsForCall[i].ctx, fake.getConferenceArgsForCall[i].sid
}

func (fake *FakeClient) GetConferenceReturns(result1 *goTwilio.Conference, result2 error) {
	fake.GetConferenceStub = nil
	fake.getConferenceReturns = struct {
		result1 *goTwilio.Conference
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferenceReturnsOnCall(i int, result1 *goTwilio.Conference, result2 error) {
	fake.GetConferenceStub = nil
	if fake.getConferenceReturnsOnCall == nil {
		fake.getConferenceReturnsOnCall = make(map[int]struct {
			result1 *goTwilio.Conference
			result2 error
		})
	}
	fake.getConferenceReturnsOnCall[i] = struct {
		result1 *goTwilio.Conference
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferences(start time.Time, end time.Time, data url.Values) goTwilio.ConferencePageIterator {
	fake.getConferencesMutex.Lock()
	ret, specificReturn := fake.getConferencesReturnsOnCall[len(fake.getConferencesArgsForCall)]
	fake.getConferencesArgsForCall = append(fake.getConferencesArgsForCall, struct {
		start time.Time
		end   time.Time
		data  url.Values
	}{start, end, data})
	fake.recordInvocation("GetConferences", []interface{}{start, end, data})
	fake.getConferencesMutex.Unlock()
	if fake.GetConferencesStub != nil {
		return fake.GetConferencesStub(start, end, data)
	}
	if specificReturn {
		return ret.result1
	}
	return fake.getConferencesReturns.result1
}

func (fake *FakeClient) GetConferencesCallCount() int {
	fake.getConferencesMutex.RLock()
	defer fake.getConferencesMutex.RUnlock()
	return len(fake.getConferencesArgsForCall)
}

func (fake *FakeClient) GetConferencesArgsForCall(i int) (time.Time, time.Time, url.Values) {
	fake.getConferencesMutex.RLock()
	defer fake.getConferencesMutex.RUnlock()
	return fake.getConferencesArgsForCall[i].start, fake.getConferencesArgsForCall[i].end, fake.getConferencesArgsForCall[i].data
}

func (fake *FakeClient) GetConferencesReturns(result1 goTwilio.ConferencePageIterator) {
	fake.GetConferencesStub = nil
	fake.getConferencesReturns = struct {
		result1 goTwilio.ConferencePageIterator
	}{result1}
}

func (fake *FakeClient) GetConferencesReturnsOnCall(i int, result1 goTwilio.ConferencePageIterator) {
	fake.GetConferencesStub = nil
	if fake.getConferencesReturnsOnCall == nil {
		fake.getConferencesReturnsOnCall = make(map[int]struct {
			result1 goTwilio.ConferencePageIterator
		})
	}
	fake.getConferencesReturnsOnCall[i] = struct {
		result1 goTwilio.ConferencePageIterator
	}{result1}
}

func (fake *FakeClient) GetCall(ctx context.Context, sid string) (*goTwilio.Call, error) {
	fake.getCallMutex.Lock()
	ret, specificReturn := fake.getCallReturnsOnCall[len(fake.getCallArgsForCall)]
	fake.getCallArgsForCall = append(fake.getCallArgsForCall, struct {
		ctx context.Context
		sid string
	}{ctx, sid})
	fake.recordInvocation("GetCall", []interface{}{ctx, sid})
	fake.getCallMutex.Unlock()
	if fake.GetCallStub != nil {
		return fake.GetCallStub(ctx, sid)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.getCallReturns.result1, fake.getCallReturns.result2
}

func (fake *FakeClient) GetCallCallCount() int {
	fake.getCallMutex.RLock()
	defer fake.getCallMutex.RUnlock()
	return len(fake.getCallArgsForCall)
}

func (fake *FakeClient) GetCallArgsForCall(i int) (context.Context, string) {
	fake.getCallMutex.RLock()
	defer fake.getCallMutex.RUnlock()
	return fake.getCallArgsForCall[i].ctx, fake.getCallArgsForCall[i].sid
}

func (fake *FakeClient) GetCallReturns(result1 *goTwilio.Call, result2 error) {
	fake.GetCallStub = nil
	fake.getCallReturns = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetCallReturnsOnCall(i int, result1 *goTwilio.Call, result2 error) {
	fake.GetCallStub = nil
	if fake.getCallReturnsOnCall == nil {
		fake.getCallReturnsOnCall = make(map[int]struct {
			result1 *goTwilio.Call
			result2 error
		})
	}
	fake.getCallReturnsOnCall[i] = struct {
		result1 *goTwilio.Call
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) RetrieveRecording(recordingURL string) (io.ReadCloser, error) {
	fake.retrieveRecordingMutex.Lock()
	ret, specificReturn := fake.retrieveRecordingReturnsOnCall[len(fake.retrieveRecordingArgsForCall)]
	fake.retrieveRecordingArgsForCall = append(fake.retrieveRecordingArgsForCall, struct {
		recordingURL string
	}{recordingURL})
	fake.recordInvocation("RetrieveRecording", []interface{}{recordingURL})
	fake.retrieveRecordingMutex.Unlock()
	if fake.RetrieveRecordingStub != nil {
		return fake.RetrieveRecordingStub(recordingURL)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.retrieveRecordingReturns.result1, fake.retrieveRecordingReturns.result2
}

func (fake *FakeClient) RetrieveRecordingCallCount() int {
	fake.retrieveRecordingMutex.RLock()
	defer fake.retrieveRecordingMutex.RUnlock()
	return len(fake.retrieveRecordingArgsForCall)
}

func (fake *FakeClient) RetrieveRecordingArgsForCall(i int) string {
	fake.retrieveRecordingMutex.RLock()
	defer fake.retrieveRecordingMutex.RUnlock()
	return fake.retrieveRecordingArgsForCall[i].recordingURL
}

func (fake *FakeClient) RetrieveRecordingReturns(result1 io.ReadCloser, result2 error) {
	fake.RetrieveRecordingStub = nil
	fake.retrieveRecordingReturns = struct {
		result1 io.ReadCloser
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) RetrieveRecordingReturnsOnCall(i int, result1 io.ReadCloser, result2 error) {
	fake.RetrieveRecordingStub = nil
	if fake.retrieveRecordingReturnsOnCall == nil {
		fake.retrieveRecordingReturnsOnCall = make(map[int]struct {
			result1 io.ReadCloser
			result2 error
		})
	}
	fake.retrieveRecordingReturnsOnCall[i] = struct {
		result1 io.ReadCloser
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferenceParticipants(ctx context.Context, conferenceSid string) (*backend.ConferenceParticipantsResponse, error) {
	fake.getConferenceParticipantsMutex.Lock()
	ret, specificReturn := fake.getConferenceParticipantsReturnsOnCall[len(fake.getConferenceParticipantsArgsForCall)]
	fake.getConferenceParticipantsArgsForCall = append(fake.getConferenceParticipantsArgsForCall, struct {
		ctx           context.Context
		conferenceSid string
	}{ctx, conferenceSid})
	fake.recordInvocation("GetConferenceParticipants", []interface{}{ctx, conferenceSid})
	fake.getConferenceParticipantsMutex.Unlock()
	if fake.GetConferenceParticipantsStub != nil {
		return fake.GetConferenceParticipantsStub(ctx, conferenceSid)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.getConferenceParticipantsReturns.result1, fake.getConferenceParticipantsReturns.result2
}

func (fake *FakeClient) GetConferenceParticipantsCallCount() int {
	fake.getConferenceParticipantsMutex.RLock()
	defer fake.getConferenceParticipantsMutex.RUnlock()
	return len(fake.getConferenceParticipantsArgsForCall)
}

func (fake *FakeClient) GetConferenceParticipantsArgsForCall(i int) (context.Context, string) {
	fake.getConferenceParticipantsMutex.RLock()
	defer fake.getConferenceParticipantsMutex.RUnlock()
	return fake.getConferenceParticipantsArgsForCall[i].ctx, fake.getConferenceParticipantsArgsForCall[i].conferenceSid
}

func (fake *FakeClient) GetConferenceParticipantsReturns(result1 *backend.ConferenceParticipantsResponse, result2 error) {
	fake.GetConferenceParticipantsStub = nil
	fake.getConferenceParticipantsReturns = struct {
		result1 *backend.ConferenceParticipantsResponse
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferenceParticipantsReturnsOnCall(i int, result1 *backend.ConferenceParticipantsResponse, result2 error) {
	fake.GetConferenceParticipantsStub = nil
	if fake.getConferenceParticipantsReturnsOnCall == nil {
		fake.getConferenceParticipantsReturnsOnCall = make(map[int]struct {
			result1 *backend.ConferenceParticipantsResponse
			result2 error
		})
	}
	fake.getConferenceParticipantsReturnsOnCall[i] = struct {
		result1 *backend.ConferenceParticipantsResponse
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferenceRecordings(ctx context.Context, conferenceSid string) (*backend.ConferenceRecordingsResponse, error) {
	fake.getConferenceRecordingsMutex.Lock()
	ret, specificReturn := fake.getConferenceRecordingsReturnsOnCall[len(fake.getConferenceRecordingsArgsForCall)]
	fake.getConferenceRecordingsArgsForCall = append(fake.getConferenceRecordingsArgsForCall, struct {
		ctx           context.Context
		conferenceSid string
	}{ctx, conferenceSid})
	fake.recordInvocation("GetConferenceRecordings", []interface{}{ctx, conferenceSid})
	fake.getConferenceRecordingsMutex.Unlock()
	if fake.GetConferenceRecordingsStub != nil {
		return fake.GetConferenceRecordingsStub(ctx, conferenceSid)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.getConferenceRecordingsReturns.result1, fake.getConferenceRecordingsReturns.result2
}

func (fake *FakeClient) GetConferenceRecordingsCallCount() int {
	fake.getConferenceRecordingsMutex.RLock()
	defer fake.getConferenceRecordingsMutex.RUnlock()
	return len(fake.getConferenceRecordingsArgsForCall)
}

func (fake *FakeClient) GetConferenceRecordingsArgsForCall(i int) (context.Context, string) {
	fake.getConferenceRecordingsMutex.RLock()
	defer fake.getConferenceRecordingsMutex.RUnlock()
	return fake.getConferenceRecordingsArgsForCall[i].ctx, fake.getConferenceRecordingsArgsForCall[i].conferenceSid
}

func (fake *FakeClient) GetConferenceRecordingsReturns(result1 *backend.ConferenceRecordingsResponse, result2 error) {
	fake.GetConferenceRecordingsStub = nil
	fake.getConferenceRecordingsReturns = struct {
		result1 *backend.ConferenceRecordingsResponse
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) GetConferenceRecordingsReturnsOnCall(i int, result1 *backend.ConferenceRecordingsResponse, result2 error) {
	fake.GetConferenceRecordingsStub = nil
	if fake.getConferenceRecordingsReturnsOnCall == nil {
		fake.getConferenceRecordingsReturnsOnCall = make(map[int]struct {
			result1 *backend.ConferenceRecordingsResponse
			result2 error
		})
	}
	fake.getConferenceRecordingsReturnsOnCall[i] = struct {
		result1 *backend.ConferenceRecordingsResponse
		result2 error
	}{result1, result2}
}

func (fake *FakeClient) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.callMutex.RLock()
	defer fake.callMutex.RUnlock()
	fake.hangupMutex.RLock()
	defer fake.hangupMutex.RUnlock()
	fake.getExpectedSignatureMutex.RLock()
	defer fake.getExpectedSignatureMutex.RUnlock()
	fake.getConferenceMutex.RLock()
	defer fake.getConferenceMutex.RUnlock()
	fake.getConferencesMutex.RLock()
	defer fake.getConferencesMutex.RUnlock()
	fake.getCallMutex.RLock()
	defer fake.getCallMutex.RUnlock()
	fake.retrieveRecordingMutex.RLock()
	defer fake.retrieveRecordingMutex.RUnlock()
	fake.getConferenceParticipantsMutex.RLock()
	defer fake.getConferenceParticipantsMutex.RUnlock()
	fake.getConferenceRecordingsMutex.RLock()
	defer fake.getConferenceRecordingsMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeClient) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ backend.Client = new(FakeClient)
