# Goosechase

Sashas initial document: https://docs.google.com/document/d/1sPXIXa5COfZQIKuxnWrsPNSN5r9ZwHVQbi1QTNfkGBA/edit

## Instructions on how to set it up

for mac:

`brew install jq`

`after first run, go to system settings -> Privacy -> Location services and allow "corelocationcli" to get location`

`make install`

`navigate to whatever directory you want to put the results in, e.g. ~/goosechase`

`create a creds.json file with AWS S3 credentials for upload (see cmd/goosechase/creds_EXAMPLE.json for layout)`

`sudo ~/bin/goosechase/goosechase`

## TODO

- Go through and normalize values (ms / mbps etc)
- Add the playlist to report.json
- Write a sync script for TCPDUMP files that can be run separatly from goosechase
- Add player-core low latency mode / non-abr mode
- Verify that our metrics are sane (especially Edgetest)
- Verify failure modes. It seems pretty robust but subject it to even more testing
- Save application log output on failure (for later debugging)

## Features

### Location

**STATUS: Done**

pkg/location

Get the "estimated" location. For OSX this is using CoreLocation API which uses WiFI triangulation to determine location. We are not expecting this to be that accurate but at least it captures a part of a city.

### Speedtest against Speedtest

**STATUS: Done**

pkg/speedtest

Point of this is to capture the "avaliable bandwidth" as Speedtest has a good amount of probes in local ISPs. Does a speedtest and logs the data with Geo of test server and latency

### Speeedtest against Edge

**STATUS: Done**

pkg/edgetest

Dustin has deployed a file (http://usher.ttvnw.net/speedtest/bbb_tmiloadtesting.mp4) on our edge. This way we can do a speedtest to our edge PoP and get the bandwidth between the user and Twitch.

### Collector

**STATUS: Done**

pkg/collector

Takes a JSON blob, saves to disk and uploads to S3 with datetime.

### Ping

**STATUS: Done**

pkg/ping

Takes an array of destinations, pings them all 5 times and returns a struct with the results.

### Player metrics

**STATUS: DONE**

pkg/playercore

Goal here is to build player core as is and capture the metrics playe-core spits out and log.

### Ingest testing

**STATUS: somewhat done, needs tidying**

pkg/ingestspeed

The goal is to get the max sustainable bitrate that can be ingested. We are doing this by streaming a file that increases in birate every 30 second and measuring when it starts erroring. This test also uses find-ingest to return the "best" ingest for the network location

### Time to Master Manifest, Playlist, Segment, First byte

**STATUS: Done**

pkg/timing

Goal here is to verify latency of player-core. Measure time to master manifest, time to rendition, time to first byte of video. By measuring these specifically seperataly we will know if player adds any loading latency

### IP address

**STATUS: Done**

pkg/ip

Get the local Ipv4, Ipv6 and the public listed ipv4, ipv6. This data tells us two things. One, if the device is behind NAT and two what IP the user has in both cases.

### MTR to edge

**STATUS: DONE**

pkg/mtr

Requested by Cyrus. Also asked for was reverse MTR but that one needs server side code.

### TCPDUMP

**STATUS: done**

pkg/tcpdump

Goal is to do a systemwide TCPDUMP as this is happening and save to disk for analyzing later.

### Route53 geo lookup

**STATUS: Not started**

pkg/route53

Lookup against live.twitch.tv and see what ingest host is returned to stream to.

### Connection Type

**STATUS: Not started**

pkg/conntype

Query the system for what connection type is being used right now. Possibly using https://osquery.io/

### Player Buffering

**STATUS: Done**

pkg/player-core

Play video and log when player-core buffers.

### Video Edge/Pop

**STATUS: Doned**

pkg/video-edge

Get which video-edge is automatically assigned to your playback session. Could be done by pulling out of player-core also.

### graphql metrics

**STATUS: Done**

Https trace POST https://gql.twitch.tv/gql with empty query (400)
Https trace POST https://gql.twitch.tv/gql with user query
Https trace POST https://gql.twitch.tv/gql with large discovery tag query and no compression

### web (index.html)

**STATUS: Done**

https trace GET https://gru.go.twitch.tv
https trace GET https://www.twitch.tv

### mweb (mobile web)

**STATUS: Done**

https trace GET https://m.twitch.tv
https trace GET https://m.twitch.tv/huntergodbr

### ugc artifacts (box art / user images, …)

**STATUS: Done, but maybe more**

https trace GET multiple profile images
https trace GET multiple box art images
https trace GET multiple preview images

**STATUS: Not started**

### branch.io redirect

**STATUS: Done**

https trace GET branch.io/... and get back the redirect

# BACKBURNER

### Test SRT

**STATUS: Not Started**

pkg/srt

Cyrus suggested testing an UDP based protocol in order to figure out if these protocols behave better on bad networks compared to RTMP
