#!/bin/bash
TESTNAME="gql"

TRACEFILE0=`mktemp`
TRACEFILE1=`mktemp`
TRACEFILE2=`mktemp`
JSONFILE=`mktemp`

FORMAT=',{
"url_effective":"%{url_effective}",
"http_connect":"%{http_connect}",
"http_code":"%{http_code}",
"http_version":"%{http_version}",
"local_ip":"%{local_ip}",
"local_port":"%{local_port}",
"num_connects":"%{num_connects}",
"num_redirects":"%{num_redirects}",
"remote_ip":"%{remote_ip}",
"remote_port":"%{remote_port}",
"size_download":"%{size_download}",
"size_header":"%{size_header}",
"size_request":"%{size_request}",
"size_upload":"%{size_upload}",
"speed_download":"%{speed_download}",
"speed_upload":"%{speed_upload}",
"time_appconnect":"%{time_appconnect}",
"time_connect":"%{time_connect}",
"time_namelookup":"%{time_namelookup}",
"time_pretransfer":"%{time_pretransfer}",
"time_redirect":"%{time_redirect}",
"time_starttransfer":"%{time_starttransfer}",
"time_total":"%{time_total}"
}'

echo "{\"${TESTNAME}\":[{}" > "${JSONFILE}"
 
curl -v -w "$FORMAT" --trace-time 'https://gql.twitch.tv/gql' -H 'Accept-Encoding: gzip, deflate, br' -H 'Content-Type: application/json' -H 'Accept: application/json' -H 'Connection: keep-alive' -H 'DNT: 1' -H 'Origin: file://' --data-binary '{"query":"{}"} ' --compressed \
  -o /dev/null  2> "${TRACEFILE0}" >> "${JSONFILE}"

curl -v -w "$FORMAT" --trace-time 'https://gql.twitch.tv/gql' -H 'Accept-Encoding: gzip, deflate, br' -H 'Content-Type: application/json' -H 'Accept: application/json' -H 'Connection: keep-alive' -H 'DNT: 1' -H 'Origin: file://' -H 'Client-Id: ps1pu6on4i1x19vo6pgcjyzckr7kr1' --data-binary '{"query":{user(login:\"lirik\"){id}}"}' --compressed \
  -o /dev/null  2> "${TRACEFILE1}" >> "${JSONFILE}"

# w/o gzip so we get a larger payload
curl -v -w "$FORMAT" --trace-time 'https://gql.twitch.tv/gql' -H 'Accept-Encoding: none' -H 'Content-Type: application/json' -H 'Accept: application/json' -H 'Connection: keep-alive' -H 'DNT: 1' -H 'Origin: file://' -H 'Client-Id: ps1pu6on4i1x19vo6pgcjyzckr7kr1' \
    --data-binary '{"operationName":"DiscoveryTabQuery","variables":{"requestId":"59d66433-b0cb-42d6-a6ef-f5fc755f4a5e","language":"en-us","langWeightedCCU":true},"extensions":{"persistedQuery":{"version":1,"sha256Hash":"4511718121fbcda40044af745a04986112bd0f437f75112c8afc430779e2301b"}},"query":"query DiscoveryTabQuery($requestId: String!, $language: String!, $langWeightedCCU: Boolean!) {  featuredStreams(language: $language, first: 8) {    __typename    isSponsored    stream {      __typename      ...StreamModelFragment    }  }  shelves(requestID: $requestId, langWeightedCCU: $langWeightedCCU, platform: \"android\") {    __typename    edges {      __typename      node {        __typename        id        displayType        trackingInfo {          __typename          reasonTarget          reasonTargetType          reasonType          rowName        }        title {          __typename          shelfTitleContext: context {            __typename            ... on Game {              name              id            }          }          key          fallbackLocalizedTitle          localizedTitleTokens {            __typename            node {              __typename              ... on Game {                ...GameModelFragment              }              ... on TextToken {                hasEmphasis                location                text              }              ... on User {                id                login                nameForDisplay: displayName              }            }          }        }        content {          __typename          edges {            __typename            trackingID            node {              __typename              ... on Stream {                ...StreamModelFragment              }              ... on Video {                ...VodModelFragment              }              ... on Clip {                ...ClipModelFragment              }              ... on Game {                ...GameModelFragment              }            }          }        }      }    }  }}fragment StreamModelFragment on Stream {  __typename  streamBroadcaster: broadcaster {    __typename    ...ChannelModelFragment  }  ...StreamModelWithoutChannelModelFragment}fragment ChannelModelFragment on User {  __typename  stream {    __typename    id    game {      __typename      id      name    }  }  ...ChannelModelWithoutStreamModelFragment}fragment ChannelModelWithoutStreamModelFragment on User {  __typename  channelId: id  profileViewCount  followers {    __typename    totalCount  }  description  login  displayName  profileImageURL(width: 300)  bannerImageURL  roles {    __typename    isPartner    isAffiliate  }}fragment StreamModelWithoutChannelModelFragment on Stream {  __typename  id  averageFPS  streamDate: createdAt  game {    __typename    name    id  }  height  previewImageURLSmall: previewImageURL(width: 80, height: 45)  previewImageURLMedium: previewImageURL(width: 320, height: 180)  previewImageURLLarge: previewImageURL(width: 640, height: 360)  previewImageURLTemplate: previewImageURL  restrictionType  restrictionOptions  self {    __typename    canWatch  }  streamTitle: title  type  streamViewCount: viewersCount  streamTags: tags {    __typename    ...TagModelFragment  }  isEncrypted}fragment TagModelFragment on Tag {  __typename  id  localizedName  tagName  isAutomated  isLanguageTag  localizedDescription}fragment GameModelFragment on Game {  __typename  id  name  viewersCount  followersCount  displayName  broadcastersCount  boxArtURL(width: 285, height: 380)  gameTags: tags(limit: 5, tagType: CONTENT) {    __typename    ...TagModelFragment  }  coverURL(width: 1600, height: 240)}fragment VodModelFragment on Video {  __typename  id  broadcastType  vodDate: createdAt  owner {    __typename    ...ChannelModelFragment  }  game {    __typename    name    id  }  self {    __typename    isRestricted  }  lengthSeconds  previewThumbnailURLMedium: previewThumbnailURL(width: 320, height: 180)  previewThumbnailURLLarge: previewThumbnailURL(width: 640, height: 360)  publishedAt  vodTitle: title  vodViewCount: viewCount  contentTags {    __typename    ...TagModelFragment  }  resourceRestriction {    __typename    type    options  }}fragment ClipModelFragment on Clip {  __typename  url  slug  createdAt  title  id  durationSeconds  viewCount  creationState  tiny: thumbnailURL(width: 86, height: 45)  small: thumbnailURL(width: 260, height: 147)  medium: thumbnailURL(width: 480, height: 272)  game {    __typename    name  }  broadcaster {    __typename    displayName    login    id    profileImageURL(width: 150)    roles {      __typename      isPartner    }  }  curator {    __typename    displayName    id    profileImageURL(width: 150)  }  broadcast {    __typename    id  }  videoQualities {    __typename    quality    frameRate    sourceURL  }  video {    __typename    id  }  videoOffsetSeconds}"}' \
    --compressed -o /dev/null  2> "${TRACEFILE2}" >> "${JSONFILE}"


echo "]}" >> "${JSONFILE}"

T0=`cat "${TRACEFILE0}" | jq -aRs '.'`
T1=`cat "${TRACEFILE1}" | jq -aRs '.'`
T2=`cat "${TRACEFILE2}" | jq -aRs '.'`

cat ${JSONFILE} | jq "del(.${TESTNAME}[0])" | jq "setpath([\"${TESTNAME}\", 0, \"trace\"]; ${T0})" | jq "setpath([\"${TESTNAME}\", 1, \"trace\"]; ${T1})" | jq "setpath([\"${TESTNAME}\", 2, \"trace\"]; ${T2})"


rm -f ${TRACEFILE0}
rm -f ${TRACEFILE1}
rm -f ${TRACEFILE2}
rm -f ${JSONFILE}
