#!/bin/bash
TESTNAME="static_assets"

TRACEFILE=`mktemp`
JSONFILE=`mktemp`

FORMAT=',{
"url_effective":"%{url_effective}",
"http_connect":"%{http_connect}",
"http_code":"%{http_code}",
"http_version":"%{http_version}",
"local_ip":"%{local_ip}",
"local_port":"%{local_port}",
"num_connects":"%{num_connects}",
"num_redirects":"%{num_redirects}",
"remote_ip":"%{remote_ip}",
"remote_port":"%{remote_port}",
"size_download":"%{size_download}",
"size_header":"%{size_header}",
"size_request":"%{size_request}",
"size_upload":"%{size_upload}",
"speed_download":"%{speed_download}",
"speed_upload":"%{speed_upload}",
"time_appconnect":"%{time_appconnect}",
"time_connect":"%{time_connect}",
"time_namelookup":"%{time_namelookup}",
"time_pretransfer":"%{time_pretransfer}",
"time_redirect":"%{time_redirect}",
"time_starttransfer":"%{time_starttransfer}",
"time_total":"%{time_total}"
}'

echo "{\"${TESTNAME}\":[{}" > "${JSONFILE}"
 

curl -v -w "$FORMAT" --trace-time  --compressed 'accept-encoding: gzip, deflate, br'\
  -o /dev/null 'https://static-cdn.jtvnw.net/jtv_user_pictures/nutellallday-profile_image-15b24ddf56be4f47-70x70.jpeg' \
  -o /dev/null 'https://static-cdn.jtvnw.net/jtv_user_pictures/f81020dd-42ae-4766-a42a-6b48ada9a14d-profile_image-70x70.png' \
  -o /dev/null 'https://static-cdn.jtvnw.net/ttv-boxart/Garena%20Free%20Fire-188x250.jpg' \
  -o /dev/null 'https://static-cdn.jtvnw.net/ttv-boxart/Call%20of%20Duty:%20Mobile-188x250.jpg' \
  -o /dev/null 'https://static-cdn.jtvnw.net/ttv-boxart/PUBG%20MOBILE-188x250.jpg' -o /dev/null 2> "${TRACEFILE}" >> "${JSONFILE}"
echo "]}" >> "${JSONFILE}"

T=`cat "${TRACEFILE}" | jq -aRs '.'`
cat ${JSONFILE} | jq "del(.${TESTNAME}[0])" | jq "setpath([\"${TESTNAME}\", 0, \"trace\"]; ${T})"

rm -f ${TRACEFILE}
rm -f ${JSONFILE}
