#!/bin/bash
TESTNAME="web"

TRACEFILE0=`mktemp`
TRACEFILE1=`mktemp`
JSONFILE=`mktemp`

FORMAT=',{
"url_effective":"%{url_effective}",
"http_connect":"%{http_connect}",
"http_code":"%{http_code}",
"http_version":"%{http_version}",
"local_ip":"%{local_ip}",
"local_port":"%{local_port}",
"num_connects":"%{num_connects}",
"num_redirects":"%{num_redirects}",
"remote_ip":"%{remote_ip}",
"remote_port":"%{remote_port}",
"size_download":"%{size_download}",
"size_header":"%{size_header}",
"size_request":"%{size_request}",
"size_upload":"%{size_upload}",
"speed_download":"%{speed_download}",
"speed_upload":"%{speed_upload}",
"time_appconnect":"%{time_appconnect}",
"time_connect":"%{time_connect}",
"time_namelookup":"%{time_namelookup}",
"time_pretransfer":"%{time_pretransfer}",
"time_redirect":"%{time_redirect}",
"time_starttransfer":"%{time_starttransfer}",
"time_total":"%{time_total}"
}'

echo "{\"${TESTNAME}\":[{}" > "${JSONFILE}"
 
curl -v -w "$FORMAT" --trace-time 'https://gru.go.twitch.tv/' -H 'Accept-Encoding: gzip, deflate, br' -H 'Connection: keep-alive' -H 'DNT: 1' --compressed \
  -o /dev/null  2> "${TRACEFILE0}" >> "${JSONFILE}"

curl -v -w "$FORMAT" --trace-time  'https://www.twitch.tv/' -H 'Accept-Encoding: gzip, deflate, br' -H 'Connection: keep-alive' -H 'DNT: 1' --compressed \
  -o /dev/null  2> "${TRACEFILE1}" >> "${JSONFILE}"

echo "]}" >> "${JSONFILE}"


T0=`cat "${TRACEFILE0}" | jq -aRs '.'`
T1=`cat "${TRACEFILE1}" | jq -aRs '.'`

cat ${JSONFILE} | jq "del(.${TESTNAME}[0])" | jq "setpath([\"${TESTNAME}\", 0, \"trace\"]; ${T0})" | jq "setpath([\"${TESTNAME}\", 1, \"trace\"]; ${T1})"

rm -f ${TRACEFILE0}
rm -f ${TRACEFILE1}
rm -f ${JSONFILE}
