package main

import (
	"code.justin.tv/event-engineering/goosechase/pkg/gps"
	"log"
	"sync"
)

const hdopThreshold = 5

func main() {
	gpsClient := gps.New("/dev/tty.usbserial", 4800)

	ch, err := gpsClient.Start()
	if err != nil {
		log.Println(err)
		return
	}

	var wg sync.WaitGroup
	wg.Add(1)

	go func() {
		defer wg.Done()

		for {
			if pos, ok := <-ch; ok {
				if pos.HDOP != 0 && pos.HDOP <= hdopThreshold {
					log.Printf("Lat: %v, Lon: %v, HDOP: %v\n", pos.Latitude, pos.Longitude, pos.HDOP)
					return
				}
			} else {
				return
			}
		}
	}()

	wg.Wait()

	gpsClient.Stop()
}
