package main

import (
	log "github.com/sirupsen/logrus"

	"code.justin.tv/event-engineering/goosechase/pkg/tcpdump"
	"fmt"
	"time"
)

func main() {

	log.Info("Started Goosechase")
	logger := log.New()
	logger.SetLevel(log.DebugLevel)

	/////////////////////////
	/// TCPDUMP
	/////////////////////////
	tcpDump := tcpdump.New("en0", "test_output", logger)

	err := tcpDump.Run()
	if err != nil {
		fmt.Println(err)
	}

	time.Sleep(time.Second * 10)

	tcpDump.Stop()
}
