package main

import (
	"os"
	"bytes"
	"fmt"
	"log"
	"os/exec"
	"regexp"
	"strings"
	"io/ioutil"
	"io"
)

func main() {
	if !fileExists("/tmp/disable.txt") {
		cmd := exec.Command("/sbin/ip", "r")

		var out bytes.Buffer
		cmd.Stdout = &out

		err := cmd.Run()

		if err != nil {
			log.Fatal(err)
		}

		output := strings.Split(out.String(), "\n")
		for _, route := range output {
			matched, _ := regexp.Match(`^default`, []byte(route))
			if matched {
				//fmt.Printf("%s\n", route)
				//default via 192.168.1.6 dev eth2 proto dhcp src 192.168.1.9 metric 205 mtu 1430
				r := regexp.MustCompile(`default via (?P<router>\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}) dev (?P<dev>eth\d) proto dhcp src \d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3} metric (?P<metric>\d{3})`)
				matches := r.FindAllStringSubmatch(route, -1)
				fmt.Printf("Waiting for goosechase to complete on %s...\n", matches[0][2])
				// Start GooseChase with our interface
				goosechase := exec.Command("/home/pi/bin/goosechase/goosechase", "-interface", matches[0][2], "-gpsdevice", "/dev/ttyUSB0", "-debuglogpath", "/home/pi/logs/goosechase.log")
				stderr, _ := goosechase.StderrPipe()
				stdin, _ := goosechase.StdinPipe()
				err := goosechase.Start()
				if err != nil {
					log.Fatal(err)
				}
				go func() {
					defer stdin.Close()
					io.WriteString(stdin, matches[0][2] + " test")
				}()
				slurperr, _ := ioutil.ReadAll(stderr)
				fmt.Printf("%s\n", slurperr)
				// Should be stuck here until child process exits
				err = goosechase.Wait()
				// Remove previous route
				fmt.Printf("Downing NIC %s\n", matches[0][2])
				cmd := exec.Command("/sbin/ip", "link", "set", "dev", matches[0][2], "down")
				removeerr := cmd.Run()

				if removeerr != nil {
					log.Fatal(removeerr)
				}
			}
		}
		rebootcmd := exec.Command("/sbin/reboot")
		rebooterr := rebootcmd.Run()
		if rebooterr != nil {
			log.Fatal(rebooterr)
		}
		os.Exit(0)
	} else {
		fmt.Printf("/tmp/disable.txt exists, exiting\n")
		os.Exit(1)
	}
}

func fileExists(filename string) bool {
	info, err := os.Stat(filename)
	if os.IsNotExist(err) {
		return false
	}
	return !info.IsDir()
}
