#include <cstdio>
#include <cstring>
#include <iostream>

#include "platforms/posix/PosixPlatform.hpp"
#include "player/MediaPlayer.hpp"
#include "player/CompositeListener.hpp"
//#include "debug/trace.hpp"

using namespace twitch;


class PosixListener : public CompositeListener {
public:
    void onAnalyticsEvent(const std::string& name, const std::string& properties) override {
        std::cout << name ;
        std::cout << properties << std::endl;
    }
};

int main(int argc, const char** argv)
{
    std::string output;
    std::string url = "http://twitch.tv/streamerhouse";
    std::string lowlatencyC = "true";
    std::string absC = "true";

    bool ll = true;
    bool abs = true;

    if (1 < argc) {
        url = argv[1];
    }

    if (2 < argc) {
        std::string cmp(argv[2]);
        if (cmp == "true") {
            ll = true;
            std::cerr << "enabling low latency" << std::endl;
        } else {
            ll = false;
            std::cerr << "disabling low latency" << std::endl;
        }
    }

    if (3 < argc) {
        std::string cmp(argv[3]);
        if (cmp == "true") {
            abs = true;
            std::cerr << "enabling ABS" << std::endl;
        } else {
            abs = false;
            std::cerr << "disabling ABS" << std::endl;
        }
    }

    PosixListener emptyListener;
    MediaPlayer player(emptyListener, std::make_shared<PosixPlatform>(false, output));
    player.setLiveLowLatencyEnabled(ll);
    player.setAutoSwitchQuality(abs);
    player.load(url);
    player.play();

    for (std::string line; std::getline(std::cin, line);) {
        // Quit on any inputline for now
        break;
    }

    player.pause();

    return EXIT_SUCCESS;
}
