package bashrunner

import (
	"os/exec"

	log "github.com/sirupsen/logrus"
)

type BashRunner struct {
	scriptfolder string
}

func New(scriptfolder string) *BashRunner {
	if scriptfolder == "" {
		scriptfolder = "./scripts/"
	}
	return &BashRunner{
		scriptfolder: scriptfolder,
	}
}

func (b *BashRunner) Name() (appname string, printname string) {
	return "bashrunner", "Bash Script Execute"
}

func (b *BashRunner) Elevated() bool {
	return false
}

func (b *BashRunner) TCPDump() bool {
	return true
}

func (b *BashRunner) Run(config map[string]string) ([]byte, error) {

	bashscript := config["script"]

	log.Info("Running bashscript: " + bashscript)

	out, err := exec.Command("/bin/bash", b.scriptfolder+bashscript).Output()
	if err != nil {
		return nil, err
	}

	return out, nil
}
